/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.ShipwreckNetherCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5314;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ShipwreckNetherStructure
extends AbstractBaseStructure<class_3111> {
    public ShipwreckNetherStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(class_3111.field_24893, locationCheckPredicate, pieceCreationPredicate);
    }

    public static ShipwreckNetherStructure create(ShipwreckNetherCodeConfig shipwreckNetherCodeConfig) {
        MutableObject box = new MutableObject();
        ShipwreckNetherStructure finalInstance = new ShipwreckNetherStructure(arg_0 -> ShipwreckNetherStructure.lambda$create$0((Mutable)box, shipwreckNetherCodeConfig, arg_0), arg_0 -> ShipwreckNetherStructure.lambda$create$1((Mutable)box, shipwreckNetherCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, ShipwreckNetherCodeConfig config) {
        class_1923 chunkPos = context.comp_309();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), context.comp_306().method_16398() + 1, chunkPos.method_8328());
        int checkRadius = 16;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                class_4966 blockView = context.comp_306().method_26261(xOffset + blockPos.method_10263(), zOffset + blockPos.method_10260(), context.comp_311());
                for (int yOffset = 0; yOffset <= 30; yOffset += 5) {
                    mutable.method_10101((class_2382)blockPos).method_10100(xOffset, yOffset, zOffset);
                    if (blockView.method_32892(mutable.method_10264()).method_26215()) continue;
                    return false;
                }
            }
        }
        int structureCheckRadius = 3;
        for (int curChunkX = chunkPos.field_9181 - structureCheckRadius; curChunkX <= chunkPos.field_9181 + structureCheckRadius; ++curChunkX) {
            for (int curChunkZ = chunkPos.field_9180 - structureCheckRadius; curChunkZ <= chunkPos.field_9180 + structureCheckRadius; ++curChunkZ) {
                for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.SHIPWRECK_AVOID_NETHER_STRUCTURE)) {
                    class_5314 structureConfig;
                    if (structureFeature == this || (structureConfig = context.comp_306().method_12109().method_28600(structureFeature)) == null || structureConfig.method_28803() <= 8) continue;
                    class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, context.comp_308(), curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, ShipwreckNetherCodeConfig config) {
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), context.comp_306().method_16398() + config.sealevelOffset, context.comp_309().method_8328());
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), 6), structureID, blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(blockpos, pieces));
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, ShipwreckNetherCodeConfig shipwreckNetherCodeConfig, class_6834.class_6835 context) {
        return ((ShipwreckNetherStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, shipwreckNetherCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, ShipwreckNetherCodeConfig shipwreckNetherCodeConfig, class_6834.class_6835 context) {
        return ((ShipwreckNetherStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, shipwreckNetherCodeConfig);
    }
}

