/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.AdvancedJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.MineshaftCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5314;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class MineshaftStructure
extends AdvancedJigsawStructure {
    public MineshaftStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static MineshaftStructure create(MineshaftCodeConfig mineshaftCodeConfig) {
        MutableObject box = new MutableObject();
        MineshaftStructure finalInstance = new MineshaftStructure(arg_0 -> MineshaftStructure.lambda$create$0((Mutable)box, mineshaftCodeConfig, arg_0), arg_0 -> MineshaftStructure.lambda$create$1((Mutable)box, mineshaftCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, MineshaftCodeConfig config) {
        class_5314 structureConfig = context.comp_306().method_12109().method_28600((class_3195)this);
        if (structureConfig != null) {
            class_2919 random = new class_2919((class_5819)new class_5820(0L));
            random.method_12663(context.comp_308() + (long)structureConfig.method_28808(), context.comp_309().field_9181, context.comp_309().field_9180);
            double d = config.probability / 10000.0;
            return random.nextDouble() < d;
        }
        return false;
    }

    @Override
    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, AdvancedJigsawStructureCodeConfig config) {
        int bottomClipOff;
        int topClipOff;
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_309().method_8326(), 0, context.comp_309().method_8328());
        if (config.maxY - config.minY <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + class_2378.field_16644.method_10221((Object)this));
        }
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.method_10104(class_2350.field_11036, structureStartHeight);
        if (config.verticalRange == null) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + config.verticalRange;
            bottomClipOff = structureStartHeight - config.verticalRange;
        }
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), config.structureSize), structureID, (class_2338)blockpos, false, false, topClipOff, bottomClipOff, (structurePiecesBuilder, pieces) -> {
            int justBelowTerrain = MineshaftStructure.getTerrainHeight(context.comp_309().method_33943(0), context.comp_306(), context.comp_311()) - 15;
            int finalJustBelowTerrain = Math.max(justBelowTerrain, bottomClipOff);
            Optional<class_3790> topPiece = pieces.stream().max(Comparator.comparingInt(piece -> piece.method_14935().method_35419()));
            if (topPiece.isPresent() && finalJustBelowTerrain < topClipOff && finalJustBelowTerrain < topPiece.get().method_14935().method_35419()) {
                int topPieceMaxY = topPiece.get().method_14935().method_35419();
                pieces.forEach(piece -> piece.method_14922(0, finalJustBelowTerrain - topPieceMaxY, 0));
            }
        });
    }

    private static int getTerrainHeight(class_2338 centerPos, class_2794 chunkGenerator, class_5539 heightLimitView) {
        int height = chunkGenerator.method_18028(centerPos.method_10263(), centerPos.method_10260(), class_2902.class_2903.field_13195, heightLimitView);
        class_2338 pos = new class_2338(centerPos.method_10263(), GeneralUtils.getMaxTerrainLimit(chunkGenerator), centerPos.method_10260());
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, chunkGenerator.method_18028(mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13195, heightLimitView));
        }
        return height;
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, MineshaftCodeConfig mineshaftCodeConfig, class_6834.class_6835 context) {
        return ((MineshaftStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, mineshaftCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, MineshaftCodeConfig mineshaftCodeConfig, class_6834.class_6835 context) {
        return ((MineshaftStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, mineshaftCodeConfig);
    }
}

