/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.AdvancedDistanceJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3443;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class AdvancedDistanceJigsawStructure
extends AdvancedJigsawStructure {
    public AdvancedDistanceJigsawStructure(Predicate<class_6834.class_6835<class_3111>> locationCheckPredicate, Function<class_6834.class_6835<class_3111>, Optional<class_6622<class_3111>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static AdvancedDistanceJigsawStructure create(AdvancedDistanceJigsawStructureCodeConfig advancedDistanceJigsawStructureCodeConfig) {
        MutableObject box = new MutableObject();
        AdvancedDistanceJigsawStructure finalInstance = new AdvancedDistanceJigsawStructure(arg_0 -> AdvancedDistanceJigsawStructure.lambda$create$0((Mutable)box, advancedDistanceJigsawStructureCodeConfig, arg_0), arg_0 -> AdvancedDistanceJigsawStructure.lambda$create$1((Mutable)box, advancedDistanceJigsawStructureCodeConfig, arg_0));
        box.setValue((Object)finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(class_6834.class_6835<class_3111> context, AdvancedDistanceJigsawStructureCodeConfig config) {
        int zBlockPos;
        int radius = config.distanceFromWorldOrigin;
        int xBlockPos = context.comp_309().method_8326();
        return xBlockPos * xBlockPos + (zBlockPos = context.comp_309().method_8328()) * zBlockPos > radius * radius;
    }

    public Optional<class_6622<class_3111>> generatePieces(class_6834.class_6835<class_3111> context, AdvancedDistanceJigsawStructureCodeConfig config) {
        int bottomClipOff;
        int topClipOff;
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_309().method_8326(), 0, context.comp_309().method_8328());
        if (config.maxY - config.minY <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + class_2378.field_16644.method_10221((Object)this));
        }
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.method_10104(class_2350.field_11036, structureStartHeight);
        if (config.verticalRange == null) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + config.verticalRange;
            bottomClipOff = structureStartHeight - config.verticalRange;
        }
        class_2960 structureID = class_2378.field_16644.method_10221((Object)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(() -> (class_3785)context.comp_314().method_30530(class_2378.field_25917).method_10223(config.startPool), config.structureSize), structureID, (class_2338)blockpos, false, false, topClipOff, bottomClipOff, (structurePiecesBuilder, pieces) -> {
            Optional<class_3790> lowestPiece = pieces.stream().min(Comparator.comparingInt(p -> p.method_14935().method_35416()));
            int minY = lowestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.method_14935().method_35416()).orElseGet(() -> ((class_2338.class_2339)blockpos).method_10264());
            if (minY < context.comp_306().method_33730()) {
                int newOffset = context.comp_306().method_33730() - minY;
                for (class_3443 piece : pieces) {
                    piece.method_14922(0, newOffset, 0);
                }
            }
        });
    }

    private static /* synthetic */ Optional lambda$create$1(Mutable box, AdvancedDistanceJigsawStructureCodeConfig advancedDistanceJigsawStructureCodeConfig, class_6834.class_6835 context) {
        return ((AdvancedDistanceJigsawStructure)((Object)box.getValue())).generatePieces((class_6834.class_6835<class_3111>)context, advancedDistanceJigsawStructureCodeConfig);
    }

    private static /* synthetic */ boolean lambda$create$0(Mutable box, AdvancedDistanceJigsawStructureCodeConfig advancedDistanceJigsawStructureCodeConfig, class_6834.class_6835 context) {
        return ((AdvancedDistanceJigsawStructure)((Object)box.getValue())).isFeatureChunk((class_6834.class_6835<class_3111>)context, advancedDistanceJigsawStructureCodeConfig);
    }
}

