/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5314;
import net.minecraft.class_6621;
import net.minecraft.class_6622;
import net.minecraft.class_6833;
import net.minecraft.class_6834;

public abstract class AbstractBaseStructure<C extends class_3037>
extends class_3195<C> {
    public AbstractBaseStructure(Codec<C> codec, Predicate<class_6834.class_6835<C>> locationCheckPredicate, Function<class_6834.class_6835<C>, Optional<class_6622<C>>> pieceCreationPredicate) {
        this(codec, locationCheckPredicate, pieceCreationPredicate, class_6621.field_34938);
    }

    public AbstractBaseStructure(Codec<C> codec, Predicate<class_6834.class_6835<C>> locationCheckPredicate, Function<class_6834.class_6835<C>, Optional<class_6622<C>>> pieceCreationPredicate, class_6621 postPlacementProcessor) {
        super(codec, context -> {
            if (!locationCheckPredicate.test(context)) {
                return Optional.empty();
            }
            return (Optional)pieceCreationPredicate.apply(context);
        }, postPlacementProcessor);
    }

    public class_2338 method_14015(class_4538 worldView, class_5138 structureManager, class_2338 blockPos, int radius, boolean skipExistingChunks, long seed, class_5314 structureConfig) {
        return this.getNearestGeneratedFeatureExpandedAndTimed(worldView, structureManager, blockPos, radius, skipExistingChunks, seed, structureConfig);
    }

    protected class_2338 getNearestGeneratedFeatureExpandedAndTimed(class_4538 worldView, class_5138 structureManager, class_2338 blockPos, int radius, boolean skipExistingChunks, long seed, class_5314 structureConfig) {
        int spacing = structureConfig.method_28803();
        int chunkX = class_4076.method_18675((int)blockPos.method_10263());
        int chunkZ = class_4076.method_18675((int)blockPos.method_10260());
        int maxRadius = radius < 100 ? radius : 50000 / structureConfig.method_28803();
        long startTime = System.currentTimeMillis();
        long abortTime = (long)(RepurposedStructures.RSAllConfig.RSMiscConfig.locateMaxTime * 1000.0);
        for (int currentRadius = 0; currentRadius <= maxRadius; ++currentRadius) {
            for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                boolean xEdge = xRadius == -currentRadius || xRadius == currentRadius;
                for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                    boolean zEdge;
                    boolean bl = zEdge = zRadius == -currentRadius || zRadius == currentRadius;
                    if (xEdge || zEdge) {
                        int trueChunkX = chunkX + spacing * xRadius;
                        int trueChunkZ = chunkZ + spacing * zRadius;
                        class_1923 chunkpos = this.method_27218(structureConfig, seed, trueChunkX, trueChunkZ);
                        class_6833 structurecheckresult = structureManager.method_39783(chunkpos, (class_3195)this, skipExistingChunks);
                        if (structurecheckresult == class_6833.field_36240) continue;
                        if (!skipExistingChunks && structurecheckresult == class_6833.field_36239) {
                            return this.method_38671(chunkpos);
                        }
                        class_2791 chunkaccess = worldView.method_22342(chunkpos.field_9181, chunkpos.field_9180, class_2806.field_16423);
                        class_3449 structurestart = structureManager.method_26975(class_4076.method_33705((class_2791)chunkaccess), (class_3195)this, (class_2810)chunkaccess);
                        if (structurestart == null || !structurestart.method_16657()) continue;
                        if (skipExistingChunks && structurestart.method_14979()) {
                            structureManager.method_39784(structurestart);
                            return this.method_38671(structurestart.method_34000());
                        }
                        if (skipExistingChunks) continue;
                        return this.method_38671(structurestart.method_34000());
                    }
                    zRadius = currentRadius - 1;
                }
            }
            if (currentRadius % 3 != 0 || System.currentTimeMillis() - startTime <= abortTime) continue;
            return null;
        }
        return null;
    }
}

