/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import net.minecraft.class_5506;

public class SafeDecodingRegistryOps<T>
extends class_5382<T> {
    private final class_5455 dynamicRegistryManager;
    private final Map<class_5321<? extends class_2378<?>>, ValueHolder<?>> valueHolders;

    public SafeDecodingRegistryOps(DynamicOps<T> delegate, class_3300 resourceManager, class_5455 dynamicRegistryManager) {
        super(delegate, class_5506.method_31154((class_3300)resourceManager), dynamicRegistryManager, Maps.newIdentityHashMap());
        this.dynamicRegistryManager = dynamicRegistryManager;
        this.valueHolders = Maps.newIdentityHashMap();
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> method_29759(T object, class_5321<? extends class_2378<E>> registryKey, Codec<E> codec, boolean allowInlineDefinitions) {
        Optional optional = this.dynamicRegistryManager.method_30527(registryKey);
        if (optional.isEmpty()) {
            return DataResult.error((String)("(Repurposed Structures SafeDecodingRegistryOps) Unknown registry: " + registryKey));
        }
        DataResult dataResult = class_2960.field_25139.decode(this.field_25503, object);
        if (dataResult.result().isEmpty()) {
            return !allowInlineDefinitions ? DataResult.error((String)"(Repurposed Structures SafeDecodingRegistryOps) Inline definitions not allowed here") : codec.decode((DynamicOps)this, object).map(pair -> pair.mapFirst(object2 -> () -> object2));
        }
        class_2385 mutableRegistry = (class_2385)optional.get();
        Pair pair2 = (Pair)dataResult.result().get();
        class_2960 identifier = (class_2960)pair2.getFirst();
        try {
            return this.readAndRegisterElement(registryKey, mutableRegistry, codec, identifier).map(supplier -> Pair.of((Object)supplier, (Object)pair2.getSecond()));
        }
        catch (Exception e) {
            return DataResult.error((String)"\nRepurposed Structures: Entry failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s".formatted(registryKey, object).indent(1));
        }
    }

    private <E> DataResult<java.util.function.Supplier<E>> readAndRegisterElement(class_5321<? extends class_2378<E>> registryRegistryKey, class_2385<E> mutableRegistry, Codec<E> codec, class_2960 elementId) {
        class_5321 elementRegistryKey = class_5321.method_29179(registryRegistryKey, (class_2960)elementId);
        ValueHolder<E> valueHolder = this.getValueHolder(registryRegistryKey);
        DataResult dataResult = valueHolder.values.get(elementRegistryKey);
        if (dataResult != null) {
            return dataResult;
        }
        Supplier supplier = Suppliers.memoize(() -> {
            Object object = mutableRegistry.method_29107(elementRegistryKey);
            if (object == null) {
                throw new RuntimeException("(Repurposed Structures SafeDecodingRegistryOps) Error during recursive registry parsing, element resolved too early: " + elementRegistryKey);
            }
            return object;
        });
        valueHolder.values.put(elementRegistryKey, DataResult.success((Object)supplier));
        DataResult dataResult4 = null;
        if (mutableRegistry.method_29107(elementRegistryKey) != null) {
            dataResult4 = DataResult.success(() -> mutableRegistry.method_29107(elementRegistryKey), (Lifecycle)Lifecycle.stable());
        }
        valueHolder.values.put(elementRegistryKey, dataResult4);
        return dataResult4;
    }

    private <E> ValueHolder<E> getValueHolder(class_5321<? extends class_2378<E>> registryRef) {
        return this.valueHolders.computeIfAbsent(registryRef, registryKey -> new ValueHolder());
    }

    static final class ValueHolder<E> {
        private final Map<class_5321<E>, DataResult<java.util.function.Supplier<E>>> values = Maps.newIdentityHashMap();

        private ValueHolder() {
        }
    }
}

