/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_20;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import org.apache.commons.lang3.EnumUtils;

public final class MobMapTrades {
    public static final Map<class_3852, List<MapTradeFinalized>> VILLAGER_MAP_TRADES = new HashMap<class_3852, List<MapTradeFinalized>>();
    public static final Map<WandingTraderTradeEntry.TRADE_TYPE, List<MapTradeFinalized>> WANDERING_TRADER_MAP_TRADES = new HashMap<WandingTraderTradeEntry.TRADE_TYPE, List<MapTradeFinalized>>();

    private MobMapTrades() {
    }

    public static void setupMapTrades() {
        MobMapTrades.setupVillagerMap(RepurposedStructures.omegaMapTradeConfig.villagerMapTrades);
        MobMapTrades.setupWanderingTraderMap(RepurposedStructures.omegaMapTradeConfig.wanderingTraderMapTrades);
    }

    private static void setupVillagerMap(Map<String, List<VillagerTradeEntry>> configMap) {
        for (Map.Entry<String, List<VillagerTradeEntry>> configMapEntry : configMap.entrySet()) {
            Optional villagerProfession = class_2378.field_17167.method_17966(new class_2960(configMapEntry.getKey()));
            if (villagerProfession.isEmpty()) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)"villager map trades");
                continue;
            }
            for (VillagerTradeEntry villagerTradeEntry : configMapEntry.getValue()) {
                class_3195 structureFeature = (class_3195)class_2378.field_16644.method_10223(new class_2960(villagerTradeEntry.structure));
                if (structureFeature == null) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown Structure {} was found in the {} config. Skipping that entry...", (Object)villagerTradeEntry.structure, (Object)"villager map trades");
                    continue;
                }
                class_20.class_21 mapIcon = (class_20.class_21)EnumUtils.getEnum(class_20.class_21.class, (String)villagerTradeEntry.mapIcon.toUpperCase(Locale.ROOT));
                if (mapIcon == null) {
                    mapIcon = class_20.class_21.field_88;
                }
                MapTradeFinalized finalizedTrade = new MapTradeFinalized(structureFeature, mapIcon, villagerTradeEntry.tradeLevel, villagerTradeEntry.emeraldsRequired, villagerTradeEntry.tradesAllowed, villagerTradeEntry.xpReward);
                if (!VILLAGER_MAP_TRADES.containsKey(villagerProfession.get())) {
                    VILLAGER_MAP_TRADES.put((class_3852)villagerProfession.get(), new ArrayList());
                }
                VILLAGER_MAP_TRADES.get(villagerProfession.get()).add(finalizedTrade);
            }
        }
    }

    private static void setupWanderingTraderMap(Map<String, List<WandingTraderTradeEntry>> configMap) {
        for (Map.Entry<String, List<WandingTraderTradeEntry>> configMapEntry : configMap.entrySet()) {
            WandingTraderTradeEntry.TRADE_TYPE tradeType = (WandingTraderTradeEntry.TRADE_TYPE)EnumUtils.getEnum(WandingTraderTradeEntry.TRADE_TYPE.class, (String)configMapEntry.getKey());
            if (tradeType == null) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)"wandering trader map trades");
                continue;
            }
            for (WandingTraderTradeEntry wandingTraderTradeEntry : configMapEntry.getValue()) {
                class_3195 structureFeature = (class_3195)class_2378.field_16644.method_10223(new class_2960(wandingTraderTradeEntry.structure));
                if (structureFeature == null) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown Structure {} was found in the {} config. Skipping that entry...", (Object)wandingTraderTradeEntry.structure, (Object)"wandering trader map trades");
                    continue;
                }
                class_20.class_21 mapIcon = (class_20.class_21)EnumUtils.getEnum(class_20.class_21.class, (String)wandingTraderTradeEntry.mapIcon.toUpperCase(Locale.ROOT));
                if (mapIcon == null) {
                    mapIcon = class_20.class_21.field_88;
                }
                MapTradeFinalized finalizedTrade = new MapTradeFinalized(structureFeature, mapIcon, 0, wandingTraderTradeEntry.emeraldsRequired, wandingTraderTradeEntry.tradesAllowed, wandingTraderTradeEntry.xpReward);
                if (!WANDERING_TRADER_MAP_TRADES.containsKey((Object)tradeType)) {
                    WANDERING_TRADER_MAP_TRADES.put(tradeType, new ArrayList());
                }
                WANDERING_TRADER_MAP_TRADES.get((Object)tradeType).add(finalizedTrade);
            }
        }
    }

    public static void addMapTrades() {
        for (Map.Entry<class_3852, List<MapTradeFinalized>> entry : VILLAGER_MAP_TRADES.entrySet()) {
            for (MapTradeFinalized mapTrade : entry.getValue()) {
                TradeOfferHelper.registerVillagerOffers((class_3852)entry.getKey(), (int)mapTrade.tradeLevel(), factories -> factories.add(new class_3853.class_1654(mapTrade.emeraldsRequired(), mapTrade.structureFeature(), mapTrade.mapIcon(), mapTrade.tradesAllowed(), mapTrade.xpReward())));
            }
        }
        for (Map.Entry<Object, List<MapTradeFinalized>> entry : WANDERING_TRADER_MAP_TRADES.entrySet()) {
            for (MapTradeFinalized mapTrade : entry.getValue()) {
                if (entry.getKey() == WandingTraderTradeEntry.TRADE_TYPE.RARE) {
                    TradeOfferHelper.registerWanderingTraderOffers((int)2, factories -> factories.add(new class_3853.class_1654(mapTrade.emeraldsRequired(), mapTrade.structureFeature(), mapTrade.mapIcon(), mapTrade.tradesAllowed(), mapTrade.xpReward())));
                    continue;
                }
                if (entry.getKey() != WandingTraderTradeEntry.TRADE_TYPE.COMMON) continue;
                TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> factories.add(new class_3853.class_1654(mapTrade.emeraldsRequired(), mapTrade.structureFeature(), mapTrade.mapIcon(), mapTrade.tradesAllowed(), mapTrade.xpReward())));
            }
        }
    }

    public static class VillagerTradeEntry {
        public final String structure;
        public final String mapIcon;
        public final int tradeLevel;
        public final int emeraldsRequired;
        public final int tradesAllowed;
        public final int xpReward;

        public VillagerTradeEntry(String structure, String mapIcon, int tradeLevel, int emeraldsRequired, int tradesAllowed, int xpReward) {
            this.structure = structure;
            this.mapIcon = mapIcon;
            this.tradeLevel = tradeLevel;
            this.emeraldsRequired = emeraldsRequired;
            this.tradesAllowed = tradesAllowed;
            this.xpReward = xpReward;
        }
    }

    public record MapTradeFinalized(class_3195<?> structureFeature, class_20.class_21 mapIcon, int tradeLevel, int emeraldsRequired, int tradesAllowed, int xpReward) {
    }

    public static class WandingTraderTradeEntry {
        public final String structure;
        public final String mapIcon;
        public final int emeraldsRequired;
        public final int tradesAllowed;
        public final int xpReward;

        public WandingTraderTradeEntry(String structure, String mapIcon, int emeraldsRequired, int tradesAllowed, int xpReward) {
            this.structure = structure;
            this.mapIcon = mapIcon;
            this.emeraldsRequired = emeraldsRequired;
            this.tradesAllowed = tradesAllowed;
            this.xpReward = xpReward;
        }

        public static enum TRADE_TYPE {
            RARE,
            COMMON;

        }
    }
}

