/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.mcdict.api;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.cottonmc.mcdict.api.Dict;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5414;

public class SimpleDict<T, V>
implements Dict<T, V> {
    private final class_2960 id;
    private final Class<V> type;
    private final Map<T, V> values;
    protected class_2378<T> registry;
    protected Supplier<class_5414<T>> group;

    public SimpleDict(class_2960 id, Class<V> type, class_2378<T> registry, Supplier<class_5414<T>> group) {
        this.id = id;
        this.type = type;
        this.registry = registry;
        this.group = group;
        this.values = new HashMap<T, V>();
    }

    @Override
    public void clear() {
        this.values().clear();
    }

    @Override
    public boolean contains(T entry) {
        return this.values.containsKey(entry);
    }

    @Override
    public Class<V> getType() {
        return this.type;
    }

    @Override
    public Collection<T> keys() {
        return this.values.keySet();
    }

    @Override
    public Map<T, V> values() {
        return this.values;
    }

    @Override
    public V get(T entry) {
        return this.values.get(entry);
    }

    @Override
    public T getRandom(Random random) {
        ArrayList list = Lists.newArrayList(this.keys());
        return (T)list.get(random.nextInt(list.size()));
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public class_3494<T> toTag() {
        return new TagDelegate(new class_2960(this.id.method_12836(), "dict/" + this.id.method_12832()), this.group);
    }

    @Override
    public void fromJson(boolean replace, boolean override, JsonObject entries) throws JsonParseException {
        Map<T, Object> vals = this.values();
        if (replace) {
            vals.clear();
        }
        for (Map.Entry jsonEntry : entries.entrySet()) {
            String key = (String)jsonEntry.getKey();
            Gson gson = new GsonBuilder().create();
            Object value = gson.fromJson(((JsonElement)jsonEntry.getValue()).toString(), this.type);
            boolean isOptional = false;
            if (value == null) {
                throw new JsonParseException("Dict value for entry " + key + " could not be parsed into type " + this.type.getName());
            }
            if (key.indexOf(63) == 0) {
                key = key.substring(1);
                isOptional = true;
            }
            if (key.indexOf(35) == 0) {
                class_3494 tag = this.group.get().method_30210(new class_2960(key.substring(1)));
                if (tag == null) {
                    if (isOptional) continue;
                    throw new JsonParseException("Dict references tag " + key + " that does not exist");
                }
                for (Object t : tag.method_15138()) {
                    if (vals.containsKey(t) && !override) continue;
                    vals.put(t, value);
                }
                continue;
            }
            Optional entry = this.registry.method_17966(new class_2960(key));
            if (entry.isEmpty()) {
                if (isOptional) continue;
                throw new JsonParseException("Dict references registered object " + key + " that does not exist");
            }
            if (vals.containsKey(entry.get()) && !override) continue;
            vals.put(entry.get(), value);
        }
        TagFactory.of(this.group).create(new class_2960(""));
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("replace", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        JsonObject vals = new JsonObject();
        for (T t : this.values().keySet()) {
            vals.addProperty(this.registry.method_10221(t).toString(), this.values.get(t).toString());
        }
        json.add("values", (JsonElement)vals);
        return json;
    }
}

