/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.mcdict.api;

import com.google.gson.GsonBuilder;
import io.github.cottonmc.mcdict.MCDict;
import io.github.cottonmc.mcdict.api.Dict;
import io.github.cottonmc.mcdict.api.IntDict;
import io.github.cottonmc.mcdict.api.SimpleDict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3611;
import net.minecraft.class_5414;
import org.jetbrains.annotations.Nullable;

public class DictManager {
    public static final Map<String, DictInfo<?>> DICT_TYPES = new HashMap();
    public static final List<Function<GsonBuilder, GsonBuilder>> FACTORIES = new ArrayList<Function<GsonBuilder, GsonBuilder>>();
    public static final DictManager DATA_PACK = new DictManager();
    public static final DictManager STATIC_DATA = new DictManager();
    public Map<String, Map<class_2960, Dict<?, ?>>> dicts = new HashMap();

    private DictManager() {
        this.innerRegisterDictType("blocks", (class_2378)class_2378.field_11146, class_3481::method_15073);
        this.innerRegisterDictType("items", (class_2378)class_2378.field_11142, class_3489::method_15106);
        this.innerRegisterDictType("fluids", (class_2378)class_2378.field_11154, class_3486::method_34889);
        this.innerRegisterDictType("entity_types", (class_2378)class_2378.field_11145, class_3483::method_15082);
    }

    public static <T> void registerDictType(String subfolder, class_2378<T> registry, Supplier<class_5414<T>> tagGroup) {
        if (DICT_TYPES.containsKey(subfolder)) {
            MCDict.logger.error("[MCDict] Could not register dict type {} as it already exists", (Object)subfolder);
            return;
        }
        DATA_PACK.innerRegisterDictType(subfolder, registry, tagGroup);
        STATIC_DATA.innerRegisterDictType(subfolder, registry, tagGroup);
    }

    private <T> void innerRegisterDictType(String subfolder, class_2378<T> registry, Supplier<class_5414<T>> tagGroup) {
        this.dicts.put(subfolder, new HashMap());
        DICT_TYPES.putIfAbsent(subfolder, new DictInfo<T>(registry, tagGroup));
    }

    public static void addValueFactory(Function<GsonBuilder, GsonBuilder> factory) {
        FACTORIES.add(factory);
    }

    @Nullable
    public <T, V> Dict<T, V> registerDict(class_2960 id, String type, Class<V> valueType) {
        if (DICT_TYPES.containsKey(type)) {
            DictInfo<?> info = DICT_TYPES.get(type);
            if (this.dicts.get(type).containsKey(id)) {
                MCDict.logger.error("[MCDict] Could not register dict {}, as it already exists for dict type {}", (Object)id.toString(), (Object)type);
                return null;
            }
            if (valueType == Integer.class) {
                IntDict ret = new IntDict(id, info.registry, info.group);
                this.dicts.get(type).put(id, ret);
                return ret;
            }
            SimpleDict ret = new SimpleDict(id, valueType, info.registry, info.group);
            this.dicts.get(type).put(id, ret);
            return ret;
        }
        MCDict.logger.error("[MCDict] Could not register dict {}, as class {} does not have a dict type", (Object)id.toString(), (Object)type);
        return null;
    }

    public <V> Dict<class_2248, V> registerBlockDict(class_2960 id, Class<V> valueType) {
        return this.registerDict(id, "blocks", valueType);
    }

    public <V> Dict<class_1792, V> registerItemDict(class_2960 id, Class<V> valueType) {
        return this.registerDict(id, "items", valueType);
    }

    public <V> Dict<class_3611, V> registerFluidDict(class_2960 id, Class<V> valueType) {
        return this.registerDict(id, "fluids", valueType);
    }

    public <V> Dict<class_1299<?>, V> registerEntityTypeDict(class_2960 id, Class<V> valueType) {
        return this.registerDict(id, "entity_types", valueType);
    }

    @Nullable
    public <T, V> Dict<T, V> getDict(String type, Class<V> valueType, class_2960 id) {
        if (!this.dicts.containsKey(type)) {
            return null;
        }
        Map<class_2960, Dict<?, ?>> dictMap = this.dicts.get(type);
        Dict<?, ?> ret = dictMap.get(id);
        if (ret.getType() == valueType) {
            return ret;
        }
        return null;
    }

    @Nullable
    public <V> Dict<class_2248, V> getBlockDict(Class<V> valueType, class_2960 id) {
        return this.getDict("blocks", valueType, id);
    }

    @Nullable
    public <V> Dict<class_1792, V> getItemDict(Class<V> valueType, class_2960 id) {
        return this.getDict("items", valueType, id);
    }

    public <V> Dict<class_3611, V> getFluidDict(Class<V> valueType, class_2960 id) {
        return this.getDict("fluids", valueType, id);
    }

    public <V> Dict<class_1299<?>, V> getEntityTypeDict(Class<V> valueType, class_2960 id) {
        return this.getDict("entity_types", valueType, id);
    }

    private static class DictInfo<T> {
        private class_2378<T> registry;
        private Supplier<class_5414<T>> group;

        private DictInfo(class_2378<T> registry, Supplier<class_5414<T>> group) {
            this.registry = registry;
            this.group = group;
        }
    }
}

