/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.mcdict;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.cottonmc.mcdict.MCDict;
import io.github.cottonmc.mcdict.api.Dict;
import io.github.cottonmc.mcdict.api.DictManager;
import io.github.cottonmc.staticdata.StaticDataItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class StaticDictLoader {
    private static final String DATA_TYPE = "dicts/";
    private static final String EXTENSION = ".json";

    public static void load() {
        GsonBuilder builder = new GsonBuilder().setLenient().setPrettyPrinting().serializeNulls();
        for (Function<GsonBuilder, GsonBuilder> factory : DictManager.FACTORIES) {
            factory.apply(builder);
        }
        Gson gson = builder.create();
        for (String key : DictManager.DICT_TYPES.keySet()) {
            Map<class_2960, Dict<?, ?>> dicts = DictManager.STATIC_DATA.dicts.get(key);
            ImmutableSet<StaticDataItem> data = StaticDictLoader.getContentInDirectory(DATA_TYPE + key);
            for (StaticDataItem item : data) {
                class_2960 id = item.getIdentifier();
                class_2960 newId = new class_2960(id.method_12836(), id.method_12832().substring(DATA_TYPE.length() + key.length() + 1, id.method_12832().length() - EXTENSION.length()));
                if (!dicts.containsKey(newId)) {
                    MCDict.logger.error("[MCDict] Tried to load dict " + newId.toString() + " that wasn't registered");
                    continue;
                }
                try {
                    Dict<?, ?> dict = dicts.get(newId);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(item.createInputStream(), StandardCharsets.UTF_8));
                    JsonObject json = (JsonObject)class_3518.method_15276((Gson)gson, (Reader)reader, JsonObject.class);
                    boolean replace = json.get("replace").getAsBoolean();
                    boolean override = json.get("override").getAsBoolean();
                    JsonObject vals = json.getAsJsonObject("values");
                    try {
                        dict.fromJson(replace, override, vals);
                    }
                    catch (JsonParseException e) {
                        MCDict.logger.error("[MCDict] Failed to load {} dict {}: {}", (Object)key, (Object)id.toString(), (Object)e.getMessage());
                    }
                }
                catch (JsonParseException | IOException e) {
                    MCDict.logger.error("[MCDict] Failed to load file(s) for dict " + id.toString() + ": " + e.getMessage());
                }
            }
        }
    }

    public static ImmutableSet<StaticDataItem> getContentInDirectory(String dirname) {
        Path contentdir;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            Path datadir;
            Path staticDataPath = container.getRootPath().resolve("static_data");
            if (!Files.isDirectory(staticDataPath, new LinkOption[0]) || !Files.isDirectory(datadir = staticDataPath.resolve(dirname), new LinkOption[0])) continue;
            try {
                Stream<Path> files = Files.walk(datadir, new FileVisitOption[0]);
                try {
                    files.forEach(it -> {
                        if (Files.isDirectory(it, new LinkOption[0])) {
                            return;
                        }
                        builder.add((Object)new StaticDataItem(StaticDictLoader.toIdentifier(container, it), it));
                    });
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Path globalStaticDataFolder = FabricLoader.getInstance().getGameDir().resolve("static_data/");
        if (Files.isDirectory(globalStaticDataFolder, new LinkOption[0]) && Files.isDirectory(contentdir = globalStaticDataFolder.resolve("content/"), new LinkOption[0])) {
            try (Stream<Path> namespaces = Files.walk(contentdir, 1, new FileVisitOption[0]);){
                namespaces.forEach(namespace -> {
                    if (namespace.equals(contentdir)) {
                        return;
                    }
                    String name = namespace.toString().substring(namespace.toString().replaceAll("\\\\", "/").lastIndexOf(47) + 1);
                    Path datadir = namespace.resolve(dirname);
                    if (Files.isDirectory(datadir, new LinkOption[0])) {
                        try (Stream<Path> files = Files.walk(datadir, new FileVisitOption[0]);){
                            files.forEach(it -> {
                                if (Files.isDirectory(it, new LinkOption[0])) {
                                    return;
                                }
                                builder.add((Object)new StaticDataItem(new class_2960(name, StaticDictLoader.getRelative(namespace, it)), it));
                            });
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    private static String getRelative(Path parent, Path child) {
        return parent.toAbsolutePath().relativize(child).toString().replace(File.separatorChar, '/').toLowerCase(Locale.ROOT).replace(' ', '_');
    }

    private static class_2960 toIdentifier(ModContainer container, Path path) {
        String rel = StaticDictLoader.getRelative(container.getRootPath(), path);
        if (rel.startsWith("static_data/")) {
            rel = rel.substring("static_data/".length());
        }
        return new class_2960(container.getMetadata().getId(), rel);
    }
}

