/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.mcdict;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.cottonmc.mcdict.MCDict;
import io.github.cottonmc.mcdict.api.Dict;
import io.github.cottonmc.mcdict.api.DictManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class PackDictLoader
implements SimpleResourceReloadListener<Map<String, Map<class_2960, List<JsonObject>>>> {
    private static final String DATA_TYPE = "dicts/";
    private static final String EXTENSION = ".json";
    private static Map<String, Map<class_2960, List<JsonObject>>> pendingDicts;

    public CompletableFuture<Map<String, Map<class_2960, List<JsonObject>>>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            GsonBuilder builder = new GsonBuilder().setLenient().setPrettyPrinting().serializeNulls();
            for (Function<GsonBuilder, GsonBuilder> factory : DictManager.FACTORIES) {
                factory.apply(builder);
            }
            Gson gson = builder.create();
            HashMap ret = new HashMap();
            for (String key : DictManager.DICT_TYPES.keySet()) {
                HashMap values = new HashMap();
                Collection resources = manager.method_14488(DATA_TYPE + key, name -> name.endsWith(EXTENSION));
                for (class_2960 id : resources) {
                    class_2960 newId = new class_2960(id.method_12836(), id.method_12832().substring(DATA_TYPE.length() + key.length() + 1, id.method_12832().length() - EXTENSION.length()));
                    if (!DictManager.DATA_PACK.dicts.get(key).containsKey(newId)) {
                        MCDict.logger.error("[MCDict] Tried to load dict " + newId.toString() + " that wasn't registered");
                        continue;
                    }
                    try {
                        List files = manager.method_14489(id);
                        ArrayList<JsonObject> allVals = new ArrayList<JsonObject>();
                        for (class_3298 file : files) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(file.method_14482(), StandardCharsets.UTF_8));
                            JsonObject json = (JsonObject)class_3518.method_15276((Gson)gson, (Reader)reader, JsonObject.class);
                            allVals.add(json);
                        }
                        values.put(newId, allVals);
                    }
                    catch (JsonParseException | IOException e) {
                        MCDict.logger.error("[MCDict] Failed to load file(s) for dict " + id.toString() + ": " + e.getMessage());
                    }
                }
                ret.put(key, values);
            }
            return ret;
        });
    }

    public CompletableFuture<Void> apply(Map<String, Map<class_2960, List<JsonObject>>> dicts, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            pendingDicts = dicts;
        });
    }

    public static CompletableFuture<Void> applyDicts() {
        return CompletableFuture.runAsync(() -> {
            for (String type : pendingDicts.keySet()) {
                Map<class_2960, Dict<?, ?>> registered = DictManager.DATA_PACK.dicts.get(type);
                registered.forEach((id, dict) -> dict.clear());
                Map<class_2960, List<JsonObject>> typeDicts = pendingDicts.get(type);
                for (class_2960 id2 : typeDicts.keySet()) {
                    Dict<?, ?> dict2 = registered.get(id2);
                    List<JsonObject> jsons = typeDicts.get(id2);
                    for (JsonObject json : jsons) {
                        boolean replace = json.get("replace").getAsBoolean();
                        boolean override = json.get("override").getAsBoolean();
                        JsonObject vals = json.getAsJsonObject("values");
                        try {
                            dict2.fromJson(replace, override, vals);
                        }
                        catch (JsonParseException e) {
                            MCDict.logger.error("[MCDict] Failed to load {} dict {}: {}", (Object)type, (Object)id2.toString(), (Object)e.getMessage());
                        }
                    }
                }
            }
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("mcdict", "dict_loader");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singletonList(ResourceReloadListenerKeys.TAGS);
    }
}

