/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.cloth.impl.utils;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import me.shedaniel.cloth.api.utils.v1.ScissorsStack;
import me.shedaniel.math.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public final class ScissorsStackImpl
implements ScissorsStack {
    private final List<Rectangle> scissorsAreas = Lists.newArrayList();
    private final Rectangle empty = new Rectangle();
    private static final Logger LOGGER = LogManager.getFormatterLogger((String)"cloth-scissors-api-v1");

    @Override
    public ScissorsStack applyScissors(Rectangle rectangle) {
        if (rectangle.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            class_1041 window = class_310.method_1551().method_22683();
            double scaleFactor = window.method_4495();
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)((double)rectangle.x * scaleFactor)), (int)((int)((double)(window.method_4502() - rectangle.height - rectangle.y) * scaleFactor)), (int)((int)((double)rectangle.width * scaleFactor)), (int)((int)((double)rectangle.height * scaleFactor)));
        }
        return this;
    }

    @Override
    public ScissorsStack push(Rectangle rectangle) {
        this.scissorsAreas.add(rectangle);
        return this;
    }

    @Override
    public ScissorsStack pushAll(Collection<Rectangle> rectangles) {
        this.scissorsAreas.addAll(rectangles);
        return this;
    }

    @Override
    public ScissorsStack pop() {
        if (this.scissorsAreas.isEmpty()) {
            throw new IllegalStateException("There is no entries in the stack!");
        }
        this.scissorsAreas.remove(this.scissorsAreas.size() - 1);
        return this;
    }

    @Override
    public List<Rectangle> getCurrentStack() {
        return this.scissorsAreas;
    }

    @Override
    public ScissorsStack applyStack() {
        if (this.scissorsAreas.isEmpty()) {
            return this.applyScissors(this.empty);
        }
        Rectangle rectangle = null;
        for (Rectangle area : this.scissorsAreas) {
            if (rectangle == null) {
                rectangle = area.clone();
                continue;
            }
            rectangle = rectangle.intersection(area);
        }
        return this.applyScissors(rectangle);
    }
}

