/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import questsadditions.events.StructurePlacementClient;
import questsadditions.tasks.TasksRegistry;

public class StructureTask
extends Task {
    public String name = "";
    public boolean hasCustomPicture;

    public StructureTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.STRUCTURE;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("name", this.name);
        nbt.method_10556("hasCustomPicture", this.hasCustomPicture);
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.name = nbt.method_10558("name");
        this.hasCustomPicture = nbt.method_10577("hasCustomPicture");
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.name, Short.MAX_VALUE);
        buffer.writeBoolean(this.hasCustomPicture);
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.name = buffer.method_10800(Short.MAX_VALUE);
        this.hasCustomPicture = buffer.readBoolean();
    }

    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("name", this.name, v -> {
            this.name = v;
        }, "");
        config.addBool("hasCustomPicture", this.hasCustomPicture, v -> {
            this.hasCustomPicture = v;
        }, false);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return new class_2588("questsadditions.task.structure.title", new Object[]{this.name});
    }

    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        list.blankLine();
        if (StructurePlacementClient.isLocked()) {
            list.add((class_2561)new class_2588("ftbquests.task.click_to_submit").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        } else {
            list.add((class_2561)new class_2588("questsadditions.structure_task.show").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.hasCustomPicture) {
            return Icon.getIcon((String)("questsadditions:textures/structure_icons/" + this.name + ".png"));
        }
        return super.getAltIcon();
    }

    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        if (!ClientQuestFile.INSTANCE.self.isCompleted((QuestObject)this)) {
            StructurePlacementClient.toggleShowStructure(this.name, this.id);
        }
    }
}

