/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.megane.runtime.util;

import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lol.bai.megane.runtime.config.MeganeConfig;
import lol.bai.megane.runtime.config.ModuleConfig;
import mcp.mobius.waila.api.IJsonConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MeganeUtils {
    public static final String MODID = "megane";
    public static final String ISSUE_URL = "https://github.com/badasintended/megane/issues";
    public static final Logger LOGGER = LogManager.getLogger((String)"megane");
    public static final int CONFIG_VERSION = 3;
    public static final IJsonConfig<MeganeConfig> CONFIG = IJsonConfig.of(MeganeConfig.class).file("waila/megane").gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create()).version(3, MeganeConfig::getConfigVersion, MeganeConfig::setConfigVersion).build();
    public static final IJsonConfig<ModuleConfig> MODULE_CONFIG = IJsonConfig.of(ModuleConfig.class).file("waila/megane_modules").build();
    public static final class_2487 EMPTY_TAG = new class_2487();
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>();
    private static final NavigableMap<Integer, String> ROMAN = new TreeMap<Integer, String>();
    public static int oldConfigVersion;
    public static boolean showUpdatedConfigToast;

    public static class_2960 id(String path) {
        return MeganeUtils.id(MODID, path);
    }

    public static class_2960 id(String namespace, String path) {
        return new class_2960(namespace, path);
    }

    public static MeganeConfig config() {
        return (MeganeConfig)CONFIG.get();
    }

    public static void reloadConfig() {
        CONFIG.invalidate();
        LOGGER.info("[megane] Loaded Config.");
    }

    @Environment(value=EnvType.CLIENT)
    public static class_2561 fluidName(class_3611 fluid) {
        class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
        return new class_2588("block." + id.method_12836() + "." + id.method_12832());
    }

    @Environment(value=EnvType.CLIENT)
    public static void drawTexture(class_4587 matrices, class_2960 id, int x, int y, int w, int h, float u0, float v0, float u1, float v1, int color) {
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)id);
        int a = 255;
        int r = MeganeUtils.getR(color);
        int g = MeganeUtils.getG(color);
        int b = MeganeUtils.getB(color);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        buffer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(u0, v1).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(u1, v1).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u1, v0).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u0, v0).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static void drawStack(class_1799 stack, int x, int y) {
        class_918 item = class_310.method_1551().method_1480();
        class_327 text = class_310.method_1551().field_1772;
        class_308.method_24211();
        RenderSystem.enableDepthTest();
        int count = stack.method_7947();
        stack.method_7939(1);
        item.method_27953(stack, x, y);
        item.method_4022(text, stack, x, y, count > 1 ? MeganeUtils.suffix(count) : "");
        stack.method_7939(count);
        class_308.method_24210();
        RenderSystem.disableDepthTest();
    }

    public static int getR(int aarrggbb) {
        return aarrggbb >> 16 & 0xFF;
    }

    public static int getG(int aarrggbb) {
        return aarrggbb >> 8 & 0xFF;
    }

    public static int getB(int aarrggbb) {
        return aarrggbb & 0xFF;
    }

    public static double getBrightness(int color) {
        return (0.299 * (double)MeganeUtils.getR(color) + 0.587 * (double)MeganeUtils.getG(color) + 0.114 * (double)MeganeUtils.getB(color)) / 255.0;
    }

    public static String suffix(long value) {
        if (value == Long.MIN_VALUE) {
            return MeganeUtils.suffix(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + MeganeUtils.suffix(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = SUFFIXES.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String toRoman(int value) {
        if (value >= 4000) {
            return String.valueOf(value);
        }
        int l = ROMAN.floorKey(value);
        if (value == l) {
            return (String)ROMAN.get(value);
        }
        return (String)ROMAN.get(l) + MeganeUtils.toRoman(value - l);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_327 textRenderer() {
        return class_310.method_1551().field_1772;
    }

    static {
        SUFFIXES.put(1000L, "K");
        SUFFIXES.put(1000000L, "M");
        SUFFIXES.put(1000000000L, "G");
        SUFFIXES.put(1000000000000L, "T");
        SUFFIXES.put(1000000000000000L, "P");
        SUFFIXES.put(1000000000000000000L, "E");
        ROMAN.put(1000, "M");
        ROMAN.put(900, "CM");
        ROMAN.put(500, "D");
        ROMAN.put(400, "CD");
        ROMAN.put(100, "C");
        ROMAN.put(90, "XC");
        ROMAN.put(50, "L");
        ROMAN.put(40, "XL");
        ROMAN.put(10, "X");
        ROMAN.put(9, "IX");
        ROMAN.put(5, "V");
        ROMAN.put(4, "IV");
        ROMAN.put(1, "I");
        oldConfigVersion = 0;
        showUpdatedConfigToast = false;
    }
}

