/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.megane.runtime.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Registry<T> {
    private final Map<Object, List<T>> objMap = new Object2ObjectOpenHashMap();
    private final Map<Class<?>, List<Entry<T>>> map = new Object2ObjectOpenHashMap();
    private final Map<Class<?>, List<T>> cache = new Object2ObjectOpenHashMap();
    private final List<Entry<?>> sorter = new ObjectArrayList();
    private final Set<Class<?>> error = new HashSet();

    public void add(Class<?> key, T val, int priority) {
        this.map.computeIfAbsent(key, k -> new ObjectArrayList()).add(new Entry<T>(val, priority));
    }

    public void add(Object key, T val) {
        this.objMap.put(key, (List<T>)ObjectLists.singleton(val));
    }

    public void error(Object obj) {
        Class<?> clazz = obj.getClass();
        this.error.add(clazz);
        this.cache.remove(clazz);
        this.map.remove(clazz);
    }

    public List<T> get(Object obj) {
        if (this.objMap.containsKey(obj)) {
            return this.objMap.get(obj);
        }
        if (obj == null) {
            return ObjectLists.emptyList();
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Object.class || this.error.contains(clazz)) {
            return ObjectLists.emptyList();
        }
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        this.sorter.clear();
        this.map.forEach((k, v) -> {
            if (k.isInstance(obj)) {
                this.sorter.addAll((Collection<Entry<?>>)v);
            }
        });
        this.sorter.sort(Comparator.comparingInt(e -> e.priority));
        ObjectArrayList list = new ObjectArrayList();
        for (Entry<?> entry : this.sorter) {
            list.add(entry.value);
        }
        if (list.isEmpty()) {
            list = ObjectLists.emptyList();
        }
        this.cache.put(clazz, (List<T>)list);
        return list;
    }

    record Entry<T>(T value, int priority) {
    }
}

