/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.megane.runtime.component;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import lol.bai.megane.runtime.util.MeganeUtils;
import mcp.mobius.waila.api.ITooltipComponent;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class BarComponent
implements ITooltipComponent {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static final class_2960 TEXTURE = MeganeUtils.id("textures/bar.png");
    private final int color;
    private final double stored;
    private final double max;
    private final String valString;

    public BarComponent(int color, double stored, double max, String unit, boolean verbose) {
        String storedString;
        this.color = color;
        this.stored = stored;
        this.max = max;
        if (stored < 0.0 || stored == Double.MAX_VALUE) {
            storedString = "\u221e";
        } else {
            String string = storedString = verbose ? String.valueOf(stored) : MeganeUtils.suffix((long)stored);
        }
        String maxString = max <= 0.0 || max == Double.MAX_VALUE ? "\u221e" : (verbose ? String.valueOf(max) : MeganeUtils.suffix((long)max));
        this.valString = storedString + "/" + maxString + (String)(unit.isEmpty() ? "" : " " + unit);
    }

    public int getWidth() {
        return Math.max(MeganeUtils.textRenderer().method_1727(this.valString), 100);
    }

    public int getHeight() {
        return 13;
    }

    public void render(class_4587 matrices, int x, int y, float delta) {
        float ratio = this.max == 0.0 ? 1.0f : (float)Math.floor(Math.min((float)(this.stored / this.max), 1.0f) * 100.0f) / 100.0f;
        MeganeUtils.drawTexture(matrices, TEXTURE, x, y, 100, 11, 0.0f, 0.0f, 1.0f, 0.5f, this.color);
        MeganeUtils.drawTexture(matrices, TEXTURE, x, y, (int)(ratio * 100.0f), 11, 0.0f, 0.5f, ratio, 1.0f, this.color);
        double brightness = MeganeUtils.getBrightness(this.color);
        int overlay = 0;
        if (brightness < 0.25) {
            overlay = 0x8FFFFFF;
        } else if (brightness > 0.9) {
            overlay = Integer.MIN_VALUE;
        } else if (brightness > 0.8) {
            overlay = 0x70000000;
        } else if (brightness > 0.7) {
            overlay = 0x60000000;
        } else if (brightness > 0.6) {
            overlay = 0x50000000;
        } else if (brightness > 0.5) {
            overlay = 0x40000000;
        }
        class_332.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + 100), (int)(y + 11), (int)overlay);
        int textWidth = MeganeUtils.textRenderer().method_1727(this.valString);
        float textX = (float)x + Math.max((float)(100 - textWidth) / 2.0f, 0.0f);
        float textY = y + 2;
        MeganeUtils.textRenderer().method_1729(matrices, this.valString, textX, textY, -5592406);
    }

    static {
        FORMAT.setRoundingMode(RoundingMode.DOWN);
    }
}

