/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DataManager
implements ISoundLists {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadData() {
        DataManager.loadMuffledMap().forEach((R, D) -> muffledSounds.put(new class_2960(R), D));
        if (!CommonConfig.get().disableAnchors().get().booleanValue()) {
            anchorList.clear();
            anchorList.addAll(DataManager.loadAnchors());
        }
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (!CommonConfig.get().disableAnchors().get().booleanValue()) {
            DataManager.saveAnchors();
        }
    }

    private static String getWorldName() {
        if (class_310.method_1551().method_1558() != null) {
            return class_310.method_1551().method_1558().field_3752;
        }
        if (class_310.method_1551().method_1576() != null) {
            return class_310.method_1551().method_1576().method_27728().method_150();
        }
        return "ServerWorld";
    }

    private static class_2487 serializeAnchor(Anchor anchor) {
        class_2487 anchorNBT = new class_2487();
        class_2487 muffledNBT = new class_2487();
        anchorNBT.method_10569("ID", anchor.getAnchorId());
        anchorNBT.method_10582("NAME", anchor.getName());
        if (anchor.getAnchorPos() == null) {
            return anchorNBT;
        }
        anchorNBT.method_10566("POS", (class_2520)class_2512.method_10692((class_2338)anchor.getAnchorPos()));
        anchorNBT.method_10582("DIM", anchor.getDimension().toString());
        anchorNBT.method_10569("RAD", anchor.getRadius());
        anchor.getMuffledSounds().forEach((R, D) -> muffledNBT.method_10549(R.toString(), D.doubleValue()));
        anchorNBT.method_10566("MUFFLED", (class_2520)muffledNBT);
        return anchorNBT;
    }

    public static Anchor deserializeAnchor(class_2487 nbt) {
        TreeMap<String, Double> muffledSounds = new TreeMap<String, Double>();
        class_2487 muffledNBT = nbt.method_10562("MUFFLED");
        for (String key : muffledNBT.method_10541()) {
            muffledSounds.put(key, muffledNBT.method_10574(key));
        }
        if (!nbt.method_10545("POS")) {
            return new Anchor(nbt.method_10550("ID"), nbt.method_10558("NAME"));
        }
        return new Anchor(nbt.method_10550("ID"), nbt.method_10558("NAME"), class_2512.method_10691((class_2487)nbt.method_10562("POS")), new class_2960(nbt.method_10558("DIM")), nbt.method_10550("RAD"), muffledSounds);
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)muffledSounds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, Double> loadMuffledMap() {
        Map map;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);
        try {
            map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Double>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                return new HashMap<String, Double>();
            }
        }
        reader.close();
        return map;
    }

    private static void saveAnchors() {
        new File("ESM/", DataManager.getWorldName()).mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)anchorList));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static List<Anchor> loadAnchors() {
        List list;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/" + DataManager.getWorldName() + "/anchors.dat"), StandardCharsets.UTF_8);
        try {
            list = (List)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<List<Anchor>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException ignored) {
                return IntStream.range(0, 10).mapToObj(i -> new Anchor(i, "Anchor " + i)).collect(Collectors.toList());
            }
        }
        reader.close();
        return list;
    }
}

