/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class Anchor {
    private final int id;
    private class_2338 anchorPos;
    private String name;
    private class_2960 dimension;
    private int Radius;
    private SortedMap<String, Double> muffledSounds = new TreeMap<String, Double>();

    public Anchor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Anchor(int id, String name, class_2338 anchorPos, class_2960 dimension, int Radius, SortedMap<String, Double> muffledSounds) {
        this.id = id;
        this.name = name;
        this.anchorPos = anchorPos;
        this.dimension = dimension;
        this.Radius = Radius;
        this.muffledSounds = muffledSounds;
    }

    public class_2338 getAnchorPos() {
        return this.anchorPos;
    }

    private void setAnchorPos(class_2338 anchorPos) {
        this.anchorPos = anchorPos;
    }

    public int getAnchorId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getRadius() {
        return this.Radius;
    }

    public void setRadius(int Radius) {
        this.Radius = Radius;
    }

    private void setName(String name) {
        this.name = name;
    }

    public SortedMap<class_2960, Double> getMuffledSounds() {
        TreeMap<class_2960, Double> temp = new TreeMap<class_2960, Double>();
        this.muffledSounds.forEach((R, D) -> temp.put(new class_2960(R), (Double)D));
        return temp;
    }

    public void setMuffledSounds(SortedMap<class_2960, Double> muffledSounds) {
        muffledSounds.forEach((R, D) -> this.muffledSounds.put(R.toString(), (Double)D));
    }

    public void addSound(class_2960 sound, double volume) {
        this.muffledSounds.put(sound.toString(), volume);
    }

    public void replaceSound(class_2960 sound, double volume) {
        this.muffledSounds.replace(sound.toString(), volume);
    }

    public String getX() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.method_10263()) : "";
    }

    public String getY() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.method_10264()) : "";
    }

    public String getZ() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.method_10260()) : "";
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    private void setDimension(class_2960 dimension) {
        this.dimension = dimension;
    }

    public void removeSound(class_2960 sound) {
        this.muffledSounds.remove(sound.toString());
    }

    public void setAnchor() {
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        this.setAnchorPos(player.method_24515());
        this.setDimension(player.field_17892.method_27983().method_29177());
        this.setRadius(this.getRadius() == 0 ? 32 : this.getRadius());
    }

    public void deleteAnchor() {
        this.setName("Anchor: " + this.getAnchorId());
        this.setAnchorPos(null);
        this.setDimension(null);
        this.setRadius(0);
        this.muffledSounds.clear();
    }

    public void editAnchor(String title, int Radius) {
        this.setName(title);
        this.setRadius(Radius);
    }

    public static Anchor getAnchor(class_1113 sound) {
        class_2338 soundPos = new class_2338(sound.method_4784(), sound.method_4779(), sound.method_4778());
        for (Anchor anchor : ISoundLists.anchorList) {
            class_638 world = class_310.method_1551().field_1687;
            if (anchor.getAnchorPos() == null || world == null || !world.method_27983().method_29177().equals((Object)anchor.getDimension()) || !soundPos.method_19771((class_2382)anchor.getAnchorPos(), (double)anchor.getRadius()) || !anchor.getMuffledSounds().containsKey(sound.method_4775())) continue;
            return anchor;
        }
        return null;
    }
}

