/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.goosikconfig.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import ru.pinkgoosik.goosikconfig.impl.AbstractConfig;

public class ConfigToJson {
    public static JsonObject convert(AbstractConfig config) {
        JsonObject object = new JsonObject();
        ConfigToJson.booleans(config, object, "");
        ConfigToJson.integers(config, object, "");
        ConfigToJson.strings(config, object, "");
        ConfigToJson.stringArrays(config, object, "");
        config.getGroups().forEach(group -> {
            JsonObject groupObject = new JsonObject();
            ConfigToJson.booleans(config, groupObject, group);
            ConfigToJson.integers(config, groupObject, group);
            ConfigToJson.strings(config, groupObject, group);
            ConfigToJson.stringArrays(config, groupObject, group);
            object.add(group, (JsonElement)groupObject);
        });
        return object;
    }

    public static void booleans(AbstractConfig config, JsonObject object, String group) {
        config.getBooleans().forEach(parameter -> {
            if (parameter.getGroup().equals(group)) {
                object.addProperty(parameter.getName(), (Boolean)parameter.getValue());
            }
        });
    }

    public static void integers(AbstractConfig config, JsonObject object, String group) {
        config.getIntegers().forEach(parameter -> {
            if (parameter.getGroup().equals(group)) {
                object.addProperty(parameter.getName(), (Number)parameter.getValue());
            }
        });
    }

    public static void strings(AbstractConfig config, JsonObject object, String group) {
        config.getStrings().forEach(parameter -> {
            if (parameter.getGroup().equals(group)) {
                object.addProperty(parameter.getName(), (String)parameter.getValue());
            }
        });
    }

    public static void stringArrays(AbstractConfig config, JsonObject object, String group) {
        config.getStringsArrays().forEach(parameter -> {
            if (parameter.getGroup().equals(group)) {
                JsonArray jsonArray = new JsonArray();
                ((ArrayList)parameter.getValue()).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
                object.add(parameter.getName(), (JsonElement)jsonArray);
            }
        });
    }
}

