/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.goosikconfig.impl;

import java.util.ArrayList;
import ru.pinkgoosik.goosikconfig.impl.parameter.BooleanParameter;
import ru.pinkgoosik.goosikconfig.impl.parameter.IntegerParameter;
import ru.pinkgoosik.goosikconfig.impl.parameter.StringParameter;
import ru.pinkgoosik.goosikconfig.impl.parameter.StringsArrayParameter;

public class AbstractConfig {
    private final String name;
    private static final ArrayList<String> EMPTY_STRINGS_ARRAY = new ArrayList();
    private final ArrayList<String> groups = new ArrayList();
    private final ArrayList<BooleanParameter> booleans = new ArrayList();
    private final ArrayList<IntegerParameter> integers = new ArrayList();
    private final ArrayList<StringParameter> strings = new ArrayList();
    private final ArrayList<StringsArrayParameter> stringsArrays = new ArrayList();

    public AbstractConfig(String name) {
        this.name = name;
    }

    public void addBoolean(String name, boolean value) {
        this.booleans.add(new BooleanParameter(name, "", value));
    }

    public void addBoolean(String name, String group, boolean value) {
        if (!group.isEmpty() && !this.groups.contains(group)) {
            this.groups.add(group);
        }
        this.booleans.add(new BooleanParameter(name, group, value));
    }

    public void addInteger(String name, int value) {
        this.integers.add(new IntegerParameter(name, "", value));
    }

    public void addInteger(String name, String group, int value) {
        if (!group.isEmpty() && !this.groups.contains(group)) {
            this.groups.add(group);
        }
        this.integers.add(new IntegerParameter(name, group, value));
    }

    public void addString(String name, String value) {
        this.strings.add(new StringParameter(name, "", value));
    }

    public void addString(String name, String group, String value) {
        if (!group.isEmpty() && !this.groups.contains(group)) {
            this.groups.add(group);
        }
        this.strings.add(new StringParameter(name, group, value));
    }

    public void addStringsArray(String name, ArrayList<String> value) {
        this.stringsArrays.add(new StringsArrayParameter(name, "", value));
    }

    public void addStringsArray(String name, String group, ArrayList<String> value) {
        if (!group.isEmpty() && !this.groups.contains(group)) {
            this.groups.add(group);
        }
        this.stringsArrays.add(new StringsArrayParameter(name, group, value));
    }

    public boolean getBoolean(String name) {
        for (BooleanParameter parameter : this.booleans) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals("")) continue;
            return (Boolean)parameter.getValue();
        }
        return true;
    }

    public boolean getBoolean(String name, String group) {
        for (BooleanParameter parameter : this.booleans) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals(group)) continue;
            return (Boolean)parameter.getValue();
        }
        return true;
    }

    public int getInteger(String name) {
        for (IntegerParameter parameter : this.integers) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals("")) continue;
            return (Integer)parameter.getValue();
        }
        return 0;
    }

    public int getInteger(String name, String group) {
        for (IntegerParameter parameter : this.integers) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals(group)) continue;
            return (Integer)parameter.getValue();
        }
        return 0;
    }

    public String getString(String name) {
        for (StringParameter parameter : this.strings) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals("")) continue;
            return (String)parameter.getValue();
        }
        return "";
    }

    public String getString(String name, String group) {
        for (StringParameter parameter : this.strings) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals(group)) continue;
            return (String)parameter.getValue();
        }
        return "";
    }

    public ArrayList<String> getStringsArray(String name) {
        for (StringsArrayParameter parameter : this.stringsArrays) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals("")) continue;
            return (ArrayList)parameter.getValue();
        }
        return EMPTY_STRINGS_ARRAY;
    }

    public ArrayList<String> getStringsArray(String name, String group) {
        for (StringsArrayParameter parameter : this.stringsArrays) {
            if (!parameter.getName().equals(name) || !parameter.getGroup().equals(group)) continue;
            return (ArrayList)parameter.getValue();
        }
        return EMPTY_STRINGS_ARRAY;
    }

    public ArrayList<String> getGroups() {
        return this.groups;
    }

    public ArrayList<BooleanParameter> getBooleans() {
        return this.booleans;
    }

    public ArrayList<IntegerParameter> getIntegers() {
        return this.integers;
    }

    public ArrayList<StringParameter> getStrings() {
        return this.strings;
    }

    public ArrayList<StringsArrayParameter> getStringsArrays() {
        return this.stringsArrays;
    }

    public void replace(AbstractConfig config) {
        this.groups.clear();
        this.groups.addAll(config.getGroups());
        this.booleans.clear();
        this.booleans.addAll(config.getBooleans());
        this.integers.clear();
        this.integers.addAll(config.getIntegers());
        this.strings.clear();
        this.strings.addAll(config.getStrings());
        this.stringsArrays.clear();
        this.stringsArrays.addAll(config.getStringsArrays());
    }

    public String getName() {
        return this.name;
    }
}

