/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.trinkets;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.proxy.IProxy;

public class TrinketsIntegration
extends EquipmentHandler {
    public static final Trinket WRAPPER = new Trinket(){

        private ItemBauble getItem(class_1799 stack) {
            return (ItemBauble)stack.method_7909();
        }

        public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!stack.method_7960()) {
                this.getItem(stack).onWornTick(stack, entity);
            }
        }

        public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!stack.method_7960()) {
                this.getItem(stack).onEquipped(stack, entity);
            }
        }

        public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!stack.method_7960()) {
                this.getItem(stack).onUnequipped(stack, entity);
            }
        }

        public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!stack.method_7960()) {
                return this.getItem(stack).canEquip(stack, entity);
            }
            return false;
        }

        public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
            Multimap ret = super.getModifiers(stack, slot, entity, uuid);
            if (!stack.method_7960()) {
                ret.putAll(this.getItem(stack).getEquippedAttributeModifiers(stack));
            }
            return ret;
        }
    };

    public static void init() {
        TrinketDropCallback.EVENT.register(TrinketsIntegration::keepAccessoryDrops);
    }

    private static TrinketEnums.DropRule keepAccessoryDrops(TrinketEnums.DropRule oldRule, class_1799 stack, SlotReference ref, class_1309 livingEntity) {
        if (ItemKeepIvy.hasIvy(stack)) {
            stack.method_7983("Botania_keepIvy");
            return TrinketEnums.DropRule.KEEP;
        }
        return oldRule;
    }

    @Override
    protected class_1263 getAllWornItems(class_1309 living) {
        return (class_1263)TrinketsApi.getTrinketComponent((class_1309)living).map(h -> {
            ArrayList<class_1799> list = new ArrayList<class_1799>();
            for (class_3545 tuple : h.getAllEquipped()) {
                class_1799 stack = (class_1799)tuple.method_15441();
                list.add(stack);
            }
            return new class_1277(list.toArray(new class_1799[0]));
        }).orElseGet(() -> new class_1277(0));
    }

    @Override
    protected class_1799 findItem(class_1792 item, class_1309 living) {
        return TrinketsApi.getTrinketComponent((class_1309)living).flatMap(h -> {
            List results = h.getEquipped(item);
            if (results.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((class_1799)((class_3545)results.get(0)).method_15441());
        }).orElse(class_1799.field_8037);
    }

    @Override
    protected class_1799 findItem(Predicate<class_1799> pred, class_1309 living) {
        return TrinketsApi.getTrinketComponent((class_1309)living).flatMap(h -> {
            List results = h.getEquipped(pred);
            if (results.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((class_1799)((class_3545)results.get(0)).method_15441());
        }).orElse(class_1799.field_8037);
    }

    @Override
    public void onInit(class_1792 item) {
        TrinketsApi.registerTrinket((class_1792)item, (Trinket)WRAPPER);
        IProxy.INSTANCE.runOnClient(() -> () -> TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new RenderWrapper()));
    }

    private static class RenderWrapper
    implements TrinketRenderer {
        private RenderWrapper() {
        }

        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
            ItemBauble item = (ItemBauble)stack.method_7909();
            if (!item.hasRender(stack, livingEntity)) {
                return;
            }
            if (!(contextModel instanceof class_572)) {
                return;
            }
            class_1799 cosmetic = item.getCosmeticItem(stack);
            if (!cosmetic.method_7960()) {
                TrinketRendererRegistry.getRenderer((class_1792)cosmetic.method_7909()).ifPresent(sub -> sub.render(cosmetic, slotReference, contextModel, matrices, vertexConsumers, light, livingEntity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch));
            } else {
                AccessoryRenderer renderer = AccessoryRenderRegistry.get(stack);
                if (renderer != null) {
                    renderer.doRender((class_572)contextModel, stack, livingEntity, matrices, vertexConsumers, light, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
                }
            }
        }
    }
}

