/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelAxe;

public class ItemTerraAxe
extends ItemManasteelAxe
implements ISequentialBreaker {
    private static final int BLOCK_SWAP_RATE = 10;
    public static final int BLOCK_RANGE = 32;
    private static final int LEAF_BLOCK_RANGE = 3;
    private static final int MANA_PER_DAMAGE = 100;
    private static final Map<class_5321<class_1937>, Set<BlockSwapper>> blockSwappers = new HashMap<class_5321<class_1937>, Set<BlockSwapper>>();
    private static boolean tickingSwappers = false;

    public ItemTerraAxe(class_1792.class_1793 props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
    }

    public static boolean shouldBreak(class_1657 player) {
        return !player.method_5715() && !ItemTemperanceStone.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        class_3965 raycast = ToolCommons.raytraceFromEntity((class_1297)player, 10.0, false);
        if (raycast.method_17783() == class_239.class_240.field_1332) {
            class_2350 face = raycast.method_17780();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.method_21823()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(class_1657 player, class_1799 stack, class_2338 pos, class_2338 originPos, class_2350 side) {
        if (ItemTerraAxe.shouldBreak(player) && !tickingSwappers) {
            ItemTerraAxe.addBlockSwapper(player.field_6002, player, stack, pos);
        }
    }

    public static void onTickEnd(class_3218 world) {
        class_5321 dim = world.method_27983();
        if (blockSwappers.containsKey(dim)) {
            tickingSwappers = true;
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
            tickingSwappers = false;
        }
    }

    private static void addBlockSwapper(class_1937 world, class_1657 player, class_1799 stack, class_2338 origCoords) {
        if (world.field_9236) {
            return;
        }
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, 32);
        class_5321 dim = world.method_27983();
        blockSwappers.computeIfAbsent((class_5321<class_1937>)dim, d -> new HashSet()).add(swapper);
    }

    private static class BlockSwapper {
        public static final int SINGLE_BLOCK_RADIUS = 1;
        private final class_1937 world;
        private final class_1657 player;
        private final class_1799 truncator;
        private final PriorityQueue<SwapCandidate> candidateQueue = new PriorityQueue();
        private final Set<class_2338> completedCoords = new HashSet<class_2338>();

        public BlockSwapper(class_1937 world, class_1657 player, class_1799 truncator, class_2338 origCoords, int range) {
            this.world = world;
            this.player = player;
            this.truncator = truncator;
            this.candidateQueue.offer(new SwapCandidate(origCoords, range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                ToolCommons.removeBlockWithDrops(this.player, this.truncator, this.world, cand.coordinates, state -> state.method_26164((class_3494)class_3481.field_33713) || state.method_26164((class_3494)class_3481.field_15503));
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (class_2338 adj : this.adjacent(cand.coordinates)) {
                    class_2248 block = this.world.method_8320(adj).method_26204();
                    boolean isWood = class_3481.field_15475.method_15141((Object)block);
                    boolean isLeaf = class_3481.field_15503.method_15141((Object)block);
                    if (!isWood && !isLeaf) continue;
                    int newRange = isLeaf ? Math.min(3, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<class_2338> adjacent(class_2338 original) {
            ArrayList<class_2338> coords = new ArrayList<class_2338>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.method_10069(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public record SwapCandidate(class_2338 coordinates, int range) implements Comparable<SwapCandidate>
        {
            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }
        }
    }
}

