/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.IProxy;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class ItemSextant
extends class_1792 {
    public static final class_2960 MULTIBLOCK_ID = ResourceLocationHelper.prefix("sextant");
    private static final int MAX_RADIUS = 256;
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourceZ";

    public ItemSextant(class_1792.class_1793 builder) {
        super(builder);
    }

    @Nonnull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
        if (this.method_7881(stack) - count < 10 || !(living instanceof class_1657) || world.field_9236) {
            return;
        }
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        if (y != Integer.MIN_VALUE) {
            double radius = ItemSextant.calculateRadius(stack, living);
            if (count % 10 == 0) {
                WispParticleData data = WispParticleData.wisp(0.3f, 0.0f, 1.0f, 1.0f, 1.0f);
                for (int i = 0; i < 360; ++i) {
                    float radian = (float)((double)i * Math.PI / 180.0);
                    double xp = (double)x + Math.cos(radian) * radius;
                    double zp = (double)z + Math.sin(radian) * radius;
                    world.method_8406((class_2394)data, xp + 0.5, (double)(y + 1), zp + 0.5, 0.0, (double)0.01f, 0.0);
                }
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int time) {
        if (!(living instanceof class_1657)) {
            return;
        }
        double radius = ItemSextant.calculateRadius(stack, living);
        if (1.0 < radius && radius <= 256.0) {
            IStateMatcher matcher = PatchouliAPI.get().predicateMatcher(class_2246.field_10445, s -> !s.method_26215());
            int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
            int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
            int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
            int iradius = (int)radius + 1;
            if (y != Integer.MIN_VALUE) {
                HashMap<class_2338, IStateMatcher> map = new HashMap<class_2338, IStateMatcher>();
                for (int i = 0; i < iradius * 2 + 1; ++i) {
                    for (int j = 0; j < iradius * 2 + 1; ++j) {
                        int xp = x + i - iradius;
                        int zp = z + j - iradius;
                        if ((int)Math.floor(MathHelper.pointDistancePlane(xp, zp, x, z)) != iradius - 1) continue;
                        map.put(new class_2338(xp - x, 0, zp - z), matcher);
                    }
                }
                IMultiblock sparse = PatchouliAPI.get().makeSparseMultiblock(map).setId(MULTIBLOCK_ID);
                IProxy.INSTANCE.showMultiblock(sparse, (class_2561)new class_2585("r = " + (int)radius), new class_2338(x, y, z), class_2470.field_11467);
            }
        }
    }

    private void reset(class_1937 world, class_1799 stack) {
        ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        if (world.field_9236) {
            IProxy.INSTANCE.clearSextantMultiblock();
        }
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!player.method_5715()) {
            class_3965 rtr = ToolCommons.raytraceFromEntity((class_1297)player, 128.0, false);
            if (rtr.method_17783() == class_239.class_240.field_1332) {
                if (!world.field_9236) {
                    class_2338 pos = rtr.method_17777();
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_X, pos.method_10263());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, pos.method_10264());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Z, pos.method_10260());
                }
                player.method_6019(hand);
            }
        } else {
            this.reset(world, stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    private static double calculateRadius(class_1799 stack, class_1309 living) {
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        class_243 source = new class_243((double)x, (double)y, (double)z);
        WispParticleData data = WispParticleData.wisp(0.2f, 1.0f, 0.0f, 0.0f, 1.0f);
        living.field_6002.method_8406((class_2394)data, source.field_1352 + 0.5, source.field_1351 + 1.0, source.field_1350 + 0.5, 0.0, (double)0.1f, 0.0);
        class_243 centerVec = VecHelper.fromEntityCenter((class_1297)living);
        class_243 diffVec = source.method_1020(centerVec);
        class_243 lookVec = living.method_5720();
        double mul = diffVec.field_1351 / lookVec.field_1351;
        lookVec = lookVec.method_1021(mul).method_1019(centerVec);
        lookVec = new class_243((double)class_3532.method_15357((double)lookVec.field_1352), lookVec.field_1351, (double)class_3532.method_15357((double)lookVec.field_1350));
        return MathHelper.pointDistancePlane(source.field_1352, source.field_1350, lookVec.field_1352, lookVec.field_1350);
    }

    public static class Hud {
        public static void render(class_4587 ms, class_1657 player, class_1799 stack) {
            class_1799 onUse = player.method_6030();
            int time = player.method_6014();
            if (onUse == stack && stack.method_7909().method_7881(stack) - time >= 10) {
                boolean inRange;
                double radius = ItemSextant.calculateRadius(stack, (class_1309)player);
                class_327 font = class_310.method_1551().field_1772;
                int x = class_310.method_1551().method_22683().method_4486() / 2 + 30;
                int y = class_310.method_1551().method_22683().method_4502() / 2;
                Object s = Integer.toString((int)radius);
                boolean bl = inRange = 0.0 < radius && radius <= 256.0;
                if (!inRange) {
                    s = class_124.field_1061 + (String)s;
                }
                font.method_1720(ms, (String)s, (float)(x - font.method_1727((String)s) / 2), (float)(y - 4), 0xFFFFFF);
                if (inRange) {
                    radius += 4.0;
                    RenderSystem.disableTexture();
                    RenderSystem.lineWidth((float)3.0f);
                    class_289.method_1348().method_1349().method_1328(class_293.class_5596.field_27378, class_290.field_1592);
                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    for (int i = 0; i < 361; ++i) {
                        float radian = (float)((double)i * Math.PI / 180.0);
                        float xp = (float)x + class_3532.method_15362((float)radian) * (float)radius;
                        float yp = (float)y + class_3532.method_15374((float)radian) * (float)radius;
                        class_289.method_1348().method_1349().method_22918(ms.method_23760().method_23761(), xp, yp, 0.0f).method_1344();
                    }
                    class_289.method_1348().method_1350();
                    RenderSystem.enableTexture();
                }
            }
        }
    }
}

