/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5632;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemManaMirror
extends class_1792
implements IManaItem {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS = "pos";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror(class_1792.class_1793 props) {
        super(props);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(this, stack));
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)(ManaBarTooltip.getFractionForDisplay(this, stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236) {
            return;
        }
        IManaPool pool = this.getManaPool(world.method_8503(), stack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                this.setMana(stack, 0);
            } else {
                pool.receiveMana(this.getManaBacklog(stack));
                this.setManaBacklog(stack, 0);
                this.setMana(stack, pool.getCurrentMana());
            }
        }
    }

    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        class_2586 tile;
        class_1937 world = ctx.method_8045();
        class_1657 player = ctx.method_8036();
        if (player != null && player.method_5715() && !world.field_9236 && (tile = world.method_8321(ctx.method_8037())) instanceof IManaPool) {
            this.bindPool(ctx.method_8041(), tile);
            world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.ding, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public int getMana(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public void setMana(class_1799 stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
    }

    public int getManaBacklog(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    public void setManaBacklog(class_1799 stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    @Override
    public int getMaxMana(class_1799 stack) {
        return 1000000;
    }

    @Override
    public void addMana(class_1799 stack, int mana) {
        this.setMana(stack, this.getMana(stack) + mana);
        this.setManaBacklog(stack, this.getManaBacklog(stack) + mana);
    }

    public void bindPool(class_1799 stack, class_2586 pool) {
        class_4208 pos = class_4208.method_19443((class_5321)pool.method_10997().method_27983(), (class_2338)pool.method_11016());
        class_2520 ser = (class_2520)class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos).get().orThrow();
        ItemNBTHelper.set(stack, TAG_POS, ser);
    }

    @Nullable
    private static class_4208 getBoundPos(class_1799 stack) {
        if (!stack.method_7948().method_10545(TAG_POS)) {
            return null;
        }
        return class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)ItemNBTHelper.get(stack, TAG_POS)).result().filter(pos -> pos.method_19446().method_10264() != Integer.MIN_VALUE).orElse(null);
    }

    @Nullable
    private IManaPool getManaPool(@Nullable MinecraftServer server, class_1799 stack) {
        class_2586 tile;
        if (server == null) {
            return fallbackPool;
        }
        class_4208 pos = ItemManaMirror.getBoundPos(stack);
        if (pos == null) {
            return fallbackPool;
        }
        class_5321 type = pos.method_19442();
        class_3218 world = server.method_3847(type);
        if (world != null && (tile = world.method_8321(pos.method_19446())) instanceof IManaPool) {
            IManaPool pool = (IManaPool)tile;
            return pool;
        }
        return null;
    }

    @Override
    public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool) {
        return false;
    }

    @Override
    public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack) {
        return false;
    }

    @Override
    public boolean canExportManaToPool(class_1799 stack, class_2586 pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(class_1799 stack) {
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void receiveMana(int mana) {
        }

        @Override
        public boolean canReceiveManaFromBursts() {
            return false;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }

        @Override
        public class_1767 getColor() {
            return class_1767.field_7952;
        }

        @Override
        public void setColor(class_1767 color) {
        }
    }

    public static class CoordBoundItem
    implements ICoordBoundItem {
        private final class_1799 stack;

        public CoordBoundItem(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public class_2338 getBinding(class_1937 world) {
            class_4208 pos = ItemManaMirror.getBoundPos(this.stack);
            if (pos == null) {
                return null;
            }
            if (pos.method_19442() == world.method_27983()) {
                return pos.method_19446();
            }
            return null;
        }
    }
}

