/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.mana;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.xplat.IXplatAbstractions;

public class ManaItemHandlerImpl
implements ManaItemHandler {
    @Override
    public List<class_1799> getManaItems(class_1657 player) {
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> toReturn = new ArrayList<class_1799>();
        for (class_1799 stackInSlot : Iterables.concat((Iterable)player.method_31548().field_7547, (Iterable)player.method_31548().field_7544)) {
            if (stackInSlot.method_7960() || !(stackInSlot.method_7909() instanceof IManaItem)) continue;
            toReturn.add(stackInSlot);
        }
        IXplatAbstractions.INSTANCE.fireManaItemEvent(player, toReturn);
        return toReturn;
    }

    @Override
    public List<class_1799> getManaAccesories(class_1657 player) {
        if (player == null) {
            return Collections.emptyList();
        }
        class_1263 acc = BotaniaAPI.instance().getAccessoriesInventory(player);
        ArrayList<class_1799> toReturn = new ArrayList<class_1799>(acc.method_5439());
        for (int slot = 0; slot < acc.method_5439(); ++slot) {
            class_1799 stackInSlot = acc.method_5438(slot);
            if (stackInSlot.method_7960() || !(stackInSlot.method_7909() instanceof IManaItem)) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    @Override
    public int requestMana(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        if (stack.method_7960()) {
            return 0;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            IManaItem requestor;
            class_1792 class_17922;
            IManaItem manaItem;
            if (stackInSlot == stack || !(manaItem = (IManaItem)stackInSlot.method_7909()).canExportManaToItem(stackInSlot, stack) || manaItem.getMana(stackInSlot) <= 0 || (class_17922 = stack.method_7909()) instanceof IManaItem && !(requestor = (IManaItem)class_17922).canReceiveManaFromItem(stack, stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItem.getMana(stackInSlot));
            if (remove) {
                manaItem.addMana(stackInSlot, -mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        return manaReceived;
    }

    @Override
    public boolean requestManaExact(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        if (stack.method_7960()) {
            return false;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        Object2IntOpenHashMap manaToRemove = new Object2IntOpenHashMap();
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            class_1792 class_17922;
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (IManaItem)stackInSlot.method_7909()).canExportManaToItem(stackInSlot, stack) || (class_17922 = stack.method_7909()) instanceof IManaItem && !(manaItem = (IManaItem)class_17922).canReceiveManaFromItem(stack, stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItemSlot.getMana(stackInSlot));
            if (remove) {
                manaToRemove.put((Object)stackInSlot, mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        if (manaReceived == manaToGet) {
            for (Object2IntMap.Entry entry : manaToRemove.object2IntEntrySet()) {
                ((IManaItem)((class_1799)entry.getKey()).method_7909()).addMana((class_1799)entry.getKey(), -entry.getIntValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public int dispatchMana(class_1799 stack, class_1657 player, int manaToSend, boolean add) {
        if (stack.method_7960()) {
            return 0;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            class_1792 class_17922;
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (IManaItem)stackInSlot.method_7909()).canReceiveManaFromItem(stackInSlot, stack) || (class_17922 = stack.method_7909()) instanceof IManaItem && !(manaItem = (IManaItem)class_17922).canExportManaToItem(stack, stackInSlot)) continue;
            int received = manaItemSlot.getMana(stackInSlot) + manaToSend <= manaItemSlot.getMaxMana(stackInSlot) ? manaToSend : manaToSend - (manaItemSlot.getMana(stackInSlot) + manaToSend - manaItemSlot.getMaxMana(stackInSlot));
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            return received;
        }
        return 0;
    }

    @Override
    public boolean dispatchManaExact(class_1799 stack, class_1657 player, int manaToSend, boolean add) {
        if (stack.method_7960()) {
            return false;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            class_1792 class_17922;
            IManaItem manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = (IManaItem)stackInSlot.method_7909()).getMana(stackInSlot) + manaToSend > manaItemSlot.getMaxMana(stackInSlot) || !manaItemSlot.canReceiveManaFromItem(stackInSlot, stack) || (class_17922 = stack.method_7909()) instanceof IManaItem && !(manaItem = (IManaItem)class_17922).canExportManaToItem(stack, stackInSlot)) continue;
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            return true;
        }
        return false;
    }

    private int discountManaForTool(class_1799 stack, class_1657 player, int inCost) {
        float multiplier = Math.max(0.0f, 1.0f - this.getFullDiscountForTools(player, stack));
        return (int)((float)inCost * multiplier);
    }

    @Override
    public int requestManaForTool(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestMana(stack, player, cost, remove);
    }

    @Override
    public boolean requestManaExactForTool(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestManaExact(stack, player, cost, remove);
    }

    @Override
    public int getInvocationCountForTool(class_1799 stack, class_1657 player, int manaToGet) {
        if (stack.method_7960()) {
            return 0;
        }
        int cost = this.discountManaForTool(stack, player, manaToGet);
        int invocations = 0;
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            class_1792 class_17922;
            if (stackInSlot == stack) continue;
            IManaItem manaItemSlot = (IManaItem)stackInSlot.method_7909();
            int availableMana = manaItemSlot.getMana(stackInSlot);
            if (!manaItemSlot.canExportManaToItem(stackInSlot, stack) || availableMana <= cost || (class_17922 = stack.method_7909()) instanceof IManaItem && !(manaItem = (IManaItem)class_17922).canReceiveManaFromItem(stack, stackInSlot)) continue;
            invocations += availableMana / cost;
        }
        return invocations;
    }

    @Override
    public float getFullDiscountForTools(class_1657 player, class_1799 tool) {
        float discount = 0.0f;
        for (int i = 0; i < player.method_31548().field_7548.size(); ++i) {
            class_1792 class_17922;
            class_1799 armor = (class_1799)player.method_31548().field_7548.get(i);
            if (armor.method_7960() || !((class_17922 = armor.method_7909()) instanceof IManaDiscountArmor)) continue;
            IManaDiscountArmor discountArmor = (IManaDiscountArmor)class_17922;
            discount += discountArmor.getDiscount(armor, i, player, tool);
        }
        int unbreaking = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)tool);
        discount += (float)unbreaking * 0.05f;
        discount = IXplatAbstractions.INSTANCE.fireManaDiscountEvent(player, discount, tool);
        return discount;
    }

    @Override
    public boolean hasProficiency(class_1657 player, class_1799 manaItem) {
        boolean proficient = false;
        for (class_1304 e : class_1304.values()) {
            IManaProficiencyArmor armor;
            class_1792 item;
            class_1799 stack;
            if (e.method_5925() != class_1304.class_1305.field_6178 || (stack = player.method_6118(e)).method_7960() || !((item = stack.method_7909()) instanceof IManaProficiencyArmor) || !(armor = (IManaProficiencyArmor)item).shouldGiveProficiency(stack, e, player, manaItem)) continue;
            proficient = true;
            break;
        }
        return IXplatAbstractions.INSTANCE.fireManaProficiencyEvent(player, manaItem, proficient);
    }
}

