/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.IXplatAbstractions;

public abstract class EquipmentHandler {
    public static EquipmentHandler instance;

    public static void init() {
        instance = IXplatAbstractions.INSTANCE.tryCreateEquipmentHandler();
        if (instance == null) {
            instance = new InventoryEquipmentHandler();
        }
    }

    public static class_1263 getAllWorn(class_1309 living) {
        return instance.getAllWornItems(living);
    }

    public static class_1799 findOrEmpty(class_1792 item, class_1309 living) {
        return instance.findItem(item, living);
    }

    public static class_1799 findOrEmpty(Predicate<class_1799> pred, class_1309 living) {
        return instance.findItem(pred, living);
    }

    protected abstract class_1263 getAllWornItems(class_1309 var1);

    protected abstract class_1799 findItem(class_1792 var1, class_1309 var2);

    protected abstract class_1799 findItem(Predicate<class_1799> var1, class_1309 var2);

    public abstract void onInit(class_1792 var1);

    public boolean isAccessory(class_1799 stack) {
        return ModTags.Items.RODS.method_15141((Object)stack.method_7909()) || stack.method_7909() instanceof ItemBauble || stack.method_7909() instanceof IManaItem;
    }

    public static class InventoryEquipmentHandler
    extends EquipmentHandler {
        private final Map<class_1657, class_1799[]> map = new WeakHashMap<class_1657, class_1799[]>();

        public void onPlayerTick(class_1657 player) {
            player.field_6002.method_16107().method_15396("botania:tick_wearables");
            class_1799[] oldStacks = this.map.computeIfAbsent(player, p -> {
                Object[] array = new class_1799[9];
                Arrays.fill(array, class_1799.field_8037);
                return array;
            });
            class_1661 inv = player.method_31548();
            for (int i = 0; i < 9; ++i) {
                class_1799 old = oldStacks[i];
                class_1799 current = inv.method_5438(i);
                if (!class_1799.method_7973((class_1799)old, (class_1799)current)) {
                    ItemBauble bauble;
                    class_1792 class_17922 = old.method_7909();
                    if (class_17922 instanceof ItemBauble) {
                        bauble = (ItemBauble)class_17922;
                        player.method_6127().method_26847(bauble.getEquippedAttributeModifiers(old));
                        bauble.onUnequipped(old, (class_1309)player);
                    }
                    if (InventoryEquipmentHandler.canEquip(current, (class_1309)player)) {
                        bauble = (ItemBauble)current.method_7909();
                        player.method_6127().method_26854(bauble.getEquippedAttributeModifiers(current));
                        bauble.onEquipped(current, (class_1309)player);
                    }
                    oldStacks[i] = current.method_7972();
                }
                if (!InventoryEquipmentHandler.canEquip(current, (class_1309)player)) continue;
                ((ItemBauble)current.method_7909()).onWornTick(current, (class_1309)player);
            }
            player.field_6002.method_16107().method_15407();
        }

        @Override
        protected class_1263 getAllWornItems(class_1309 living) {
            return new class_1277(0);
        }

        @Override
        protected class_1799 findItem(class_1792 item, class_1309 living) {
            if (living instanceof class_1657) {
                class_1657 player = (class_1657)living;
                class_1661 inv = player.method_31548();
                for (int i = 0; i < 9; ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (!stack.method_31574(item) || !InventoryEquipmentHandler.canEquip(stack, living)) continue;
                    return stack;
                }
            }
            return class_1799.field_8037;
        }

        @Override
        protected class_1799 findItem(Predicate<class_1799> pred, class_1309 living) {
            if (living instanceof class_1657) {
                class_1657 player = (class_1657)living;
                class_1661 inv = player.method_31548();
                for (int i = 0; i < 9; ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (!pred.test(stack) || !InventoryEquipmentHandler.canEquip(stack, living)) continue;
                    return stack;
                }
            }
            return class_1799.field_8037;
        }

        @Override
        public void onInit(class_1792 item) {
        }

        private static boolean canEquip(class_1799 stack, class_1309 player) {
            ItemBauble bauble;
            class_1792 class_17922 = stack.method_7909();
            return class_17922 instanceof ItemBauble && (bauble = (ItemBauble)class_17922).canEquip(stack, player);
        }
    }
}

