/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeOrechid;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class RecipeMarimorphosis
extends RecipeOrechid {
    private final int weightBonus;
    private final Set<class_1959.class_1961> biomes;

    public RecipeMarimorphosis(class_2960 id, class_2248 input, StateIngredient output, int weight, int weightBonus, Collection<class_1959.class_1961> biomes) {
        super(id, input, output, weight);
        this.weightBonus = weightBonus;
        this.biomes = Set.copyOf(biomes);
    }

    @Override
    public int getWeight(@Nonnull class_1937 level, @Nonnull class_2338 pos) {
        class_1959 biome = level.method_23753(pos);
        if (this.biomes.contains(biome.method_8688())) {
            return this.getWeight() + this.weightBonus;
        }
        return this.getWeight();
    }

    @Override
    public class_3956<?> method_17716() {
        return ModRecipeTypes.MARIMORPHOSIS_TYPE;
    }

    @Override
    public class_1865<?> method_8119() {
        return ModRecipeTypes.MARIMORPHOSIS_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeMarimorphosis> {
        public RecipeMarimorphosis fromJson(@Nonnull class_2960 recipeId, @Nonnull JsonObject json) {
            RecipeOrechid base = (RecipeOrechid)ModRecipeTypes.ORECHID_SERIALIZER.method_8121(recipeId, json);
            HashSet<class_1959.class_1961> biomes = new HashSet<class_1959.class_1961>();
            JsonArray array = class_3518.method_15292((JsonObject)json, (String)"biomes", (JsonArray)new JsonArray());
            for (JsonElement element : array) {
                biomes.add(class_1959.class_1961.method_28424((String)class_3518.method_15287((JsonElement)element, (String)"biome entry")));
            }
            int weightBonus = class_3518.method_15282((JsonObject)json, (String)"biome_bonus", (int)0);
            if (base.getWeight() + weightBonus <= 0) {
                throw new JsonSyntaxException("Weight combined with bonus cannot be 0 or less");
            }
            return new RecipeMarimorphosis(recipeId, base.getInput(), base.getOutput(), base.getWeight(), weightBonus, biomes);
        }

        public RecipeMarimorphosis fromNetwork(@Nonnull class_2960 recipeId, @Nonnull class_2540 buffer) {
            RecipeOrechid base = (RecipeOrechid)ModRecipeTypes.ORECHID_SERIALIZER.method_8122(recipeId, buffer);
            HashSet<class_1959.class_1961> biomes = new HashSet<class_1959.class_1961>();
            int size = buffer.method_10816();
            for (int i = 0; i < size; ++i) {
                biomes.add(class_1959.class_1961.method_28424((String)buffer.method_19772()));
            }
            int weightBonus = buffer.method_10816();
            return new RecipeMarimorphosis(recipeId, base.getInput(), base.getOutput(), base.getWeight(), weightBonus, biomes);
        }

        public void toNetwork(@Nonnull class_2540 buffer, @Nonnull RecipeMarimorphosis recipe) {
            ModRecipeTypes.ORECHID_SERIALIZER.method_8124(buffer, (class_1860)recipe);
            buffer.method_10804(recipe.biomes.size());
            for (class_1959.class_1961 biomeCategory : recipe.biomes) {
                buffer.method_10814(biomeCategory.method_15434());
            }
            buffer.method_10804(recipe.weightBonus);
        }
    }
}

