/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileCorporeaRetainer
extends TileMod
implements IWandable {
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    private static final String TAG_RETAIN_MISSING = "retainMissing";
    private static final Map<class_2960, Function<class_2487, ? extends ICorporeaRequestMatcher>> corporeaMatcherDeserializers = new ConcurrentHashMap<class_2960, Function<class_2487, ? extends ICorporeaRequestMatcher>>();
    private static final Map<Class<? extends ICorporeaRequestMatcher>, class_2960> corporeaMatcherSerializers = new ConcurrentHashMap<Class<? extends ICorporeaRequestMatcher>, class_2960>();
    private class_2338 requestPos = class_2338.field_10980;
    @Nullable
    private ICorporeaRequestMatcher request;
    private int requestCount;
    private int compValue;
    private boolean retainMissing = false;

    public TileCorporeaRetainer(class_2338 pos, class_2680 state) {
        super(ModTiles.CORPOREA_RETAINER, pos, state);
    }

    public void remember(class_2338 pos, ICorporeaRequestMatcher request, int count, int missing) {
        if (this.hasPendingRequest()) {
            return;
        }
        this.requestPos = pos;
        this.request = request;
        this.requestCount = this.retainMissing ? missing : count;
        this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.requestCount);
        this.method_5431();
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    public boolean hasPendingRequest() {
        return this.request != null;
    }

    public void fulfilRequest() {
        class_2586 te;
        if (!this.hasPendingRequest()) {
            return;
        }
        ICorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(this.field_11863, this.requestPos);
        if (spark != null && (te = spark.getSparkNode().getWorld().method_8321(spark.getSparkNode().getPos())) instanceof ICorporeaRequestor) {
            ICorporeaRequestor requestor = (ICorporeaRequestor)te;
            requestor.doCorporeaRequest(this.request, this.requestCount, spark);
            this.request = null;
            this.requestCount = 0;
            this.compValue = 0;
            this.method_5431();
        }
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        class_2960 reqType;
        super.writePacketNBT(cmp);
        cmp.method_10569(TAG_REQUEST_X, this.requestPos.method_10263());
        cmp.method_10569(TAG_REQUEST_Y, this.requestPos.method_10264());
        cmp.method_10569(TAG_REQUEST_Z, this.requestPos.method_10260());
        class_2960 class_29602 = reqType = this.request != null ? corporeaMatcherSerializers.get(this.request.getClass()) : null;
        if (reqType != null) {
            cmp.method_10582(TAG_REQUEST_TYPE, reqType.toString());
            this.request.writeToNBT(cmp);
            cmp.method_10569(TAG_REQUEST_COUNT, this.requestCount);
        }
        cmp.method_10556(TAG_RETAIN_MISSING, this.retainMissing);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        super.readPacketNBT(cmp);
        int x = cmp.method_10550(TAG_REQUEST_X);
        int y = cmp.method_10550(TAG_REQUEST_Y);
        int z = cmp.method_10550(TAG_REQUEST_Z);
        this.requestPos = new class_2338(x, y, z);
        class_2960 reqType = class_2960.method_12829((String)cmp.method_10558(TAG_REQUEST_TYPE));
        this.request = reqType != null && corporeaMatcherDeserializers.containsKey(reqType) ? corporeaMatcherDeserializers.get(reqType).apply(cmp) : null;
        this.requestCount = cmp.method_10550(TAG_REQUEST_COUNT);
        this.retainMissing = cmp.method_10577(TAG_RETAIN_MISSING);
    }

    public static <T extends ICorporeaRequestMatcher> void addCorporeaRequestMatcher(class_2960 id, Class<T> clazz, Function<class_2487, T> deserializer) {
        corporeaMatcherSerializers.put(clazz, id);
        corporeaMatcherDeserializers.put(id, deserializer);
    }

    @Override
    public boolean onUsedByWand(class_1657 player, class_1799 stack, class_2350 side) {
        if (!this.field_11863.field_9236) {
            this.retainMissing = !this.retainMissing;
            this.method_5431();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public static class WandHud
    implements IWandHUD {
        private final TileCorporeaRetainer retainer;

        public WandHud(TileCorporeaRetainer retainer) {
            this.retainer = retainer;
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            String mode = class_1074.method_4662((String)("botaniamisc.retainer." + (this.retainer.retainMissing ? "retain_missing" : "retain_all")), (Object[])new Object[0]);
            int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(mode) / 2;
            int y = mc.method_22683().method_4502() / 2 + 10;
            mc.field_1772.method_1720(ms, mode, (float)x, (float)y, class_124.field_1080.method_532().intValue());
        }
    }
}

