/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class TileEnchanter
extends TileMod
implements ISparkAttachable,
IWandable {
    private static final String TAG_STAGE = "stage";
    private static final String TAG_STAGE_TICKS = "stageTicks";
    private static final String TAG_STAGE_3_END_TICKS = "stage3EndTicks";
    private static final String TAG_MANA_REQUIRED = "manaRequired";
    private static final String TAG_MANA = "mana";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ENCHANTS = "enchantsToApply";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final String[][] PATTERN = new String[][]{{"_P_______P_", "___________", "___________", "P_________P", "___________", "___________", "_P_______P_"}, {"_F_______F_", "___________", "____F_F____", "F____L____F", "____F_F____", "___________", "_F_______F_"}, {"___________", "____BBB____", "___B_B_B___", "___BB0BB___", "___B_B_B___", "____BBB____", "___________"}};
    private static final Supplier<IStateMatcher> OBSIDIAN_MATCHER = Suppliers.memoize(() -> PatchouliAPI.get().predicateMatcher(class_2246.field_10540, state -> state.method_27852(class_2246.field_10540) || state.method_27852(class_2246.field_22423)));
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), ModBlocks.manaPylon, Character.valueOf('L'), class_2246.field_10441, Character.valueOf('B'), OBSIDIAN_MATCHER.get(), Character.valueOf('0'), OBSIDIAN_MATCHER.get(), Character.valueOf('F'), PatchouliAPI.get().predicateMatcher(ModBlocks.whiteFlower, state -> state.method_26164(ModTags.Blocks.ENCHANTER_FLOWERS))}));
    private static final Supplier<IMultiblock> FORMED_MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), ModBlocks.manaPylon, Character.valueOf('L'), ModBlocks.enchanter, Character.valueOf('B'), OBSIDIAN_MATCHER.get(), Character.valueOf('0'), OBSIDIAN_MATCHER.get(), Character.valueOf('F'), PatchouliAPI.get().predicateMatcher(ModBlocks.whiteFlower, state -> state.method_26164(ModTags.Blocks.ENCHANTER_FLOWERS))}));
    public State stage = State.IDLE;
    public int stageTicks = 0;
    public int stage3EndTicks = 0;
    private int manaRequired = -1;
    private int mana = 0;
    public class_1799 itemToEnchant = class_1799.field_8037;
    private final List<class_1889> enchants = new ArrayList<class_1889>();
    private static final Map<class_2350.class_2351, class_2338[]> PYLON_LOCATIONS = new EnumMap<class_2350.class_2351, class_2338[]>(class_2350.class_2351.class);

    public TileEnchanter(class_2338 pos, class_2680 state) {
        super(ModTiles.ENCHANTER, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
        if (this.stage != State.IDLE || this.itemToEnchant.method_7960() || !this.itemToEnchant.method_7923()) {
            return false;
        }
        List items = this.field_11863.method_18467(class_1542.class, new class_238((double)(this.field_11867.method_10263() - 2), (double)this.field_11867.method_10264(), (double)(this.field_11867.method_10260() - 2), (double)(this.field_11867.method_10263() + 3), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 3)));
        int count = items.size();
        if (count > 0 && !this.field_11863.field_9236) {
            for (class_1542 entity : items) {
                class_1887 enchant;
                Map enchants;
                class_1799 item = entity.method_6983();
                if (!item.method_31574(class_1802.field_8598) || (enchants = class_1890.method_8222((class_1799)item)).size() <= 0 || !this.isEnchantmentValid(enchant = (class_1887)enchants.keySet().iterator().next())) continue;
                this.advanceStage();
                return true;
            }
        }
        return false;
    }

    private void gatherEnchants() {
        if (!this.field_11863.field_9236 && this.stageTicks % 20 == 0) {
            List items = this.field_11863.method_18467(class_1542.class, new class_238((double)(this.field_11867.method_10263() - 2), (double)this.field_11867.method_10264(), (double)(this.field_11867.method_10260() - 2), (double)(this.field_11867.method_10263() + 3), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 3)));
            boolean addedEnch = false;
            for (class_1542 entity : items) {
                Map enchants;
                class_1799 item = entity.method_6983();
                if (!item.method_31574(class_1802.field_8598) || (enchants = class_1890.method_8222((class_1799)item)).size() <= 0) continue;
                Map.Entry e = enchants.entrySet().iterator().next();
                class_1887 ench = (class_1887)e.getKey();
                int enchantLvl = (Integer)e.getValue();
                if (this.hasEnchantAlready(ench) || !this.isEnchantmentValid(ench)) continue;
                this.enchants.add(new class_1889(ench, enchantLvl));
                this.field_11863.method_8396(null, this.field_11867, ModSounds.ding, class_3419.field_15245, 1.0f, 1.0f);
                addedEnch = true;
                break;
            }
            if (!addedEnch) {
                if (this.enchants.isEmpty()) {
                    this.stage = State.IDLE;
                } else {
                    this.advanceStage();
                }
            }
        }
    }

    private void gatherMana(class_2350.class_2351 axis) {
        if (this.manaRequired == -1) {
            this.manaRequired = 0;
            for (class_1889 data : this.enchants) {
                this.manaRequired += (int)(5000.0f * ((float)(15 - Math.min(15, data.field_9093.method_8186().method_8197())) * 1.05f) * ((3.0f + (float)(data.field_9094 * data.field_9094)) * 0.25f) * (0.9f + (float)this.enchants.size() * 0.05f) * (data.field_9093.method_8193() ? 1.25f : 1.0f));
            }
        } else if (this.mana >= this.manaRequired) {
            this.manaRequired = 0;
            for (class_2338 offset : PYLON_LOCATIONS.get(axis)) {
                class_2586 te = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)offset));
                if (!(te instanceof TilePylon)) continue;
                TilePylon pylon = (TilePylon)te;
                pylon.activated = false;
            }
            this.advanceStage();
        } else {
            IManaSpark spark = this.getAttachedSpark();
            if (spark != null) {
                SparkHelper.getSparksAround(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, spark.getNetwork()).filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedTile() instanceof IManaPool).forEach(os -> os.registerTransfer(spark));
            }
            if (this.stageTicks % 5 == 0) {
                this.sync();
            }
        }
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileEnchanter self) {
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(BotaniaStateProps.ENCHANTER_DIRECTION);
        for (class_2338 offset : PYLON_LOCATIONS.get(axis)) {
            class_2586 tile = level.method_8321(worldPosition.method_10081((class_2382)offset));
            if (!(tile instanceof TilePylon)) continue;
            TilePylon pylon = (TilePylon)tile;
            boolean bl = pylon.activated = self.stage == State.GATHER_MANA;
            if (self.stage != State.GATHER_MANA) continue;
            pylon.centerPos = worldPosition;
        }
        if (self.stage != State.IDLE) {
            ++self.stageTicks;
        }
        if (level.field_9236) {
            return;
        }
        if (FORMED_MULTIBLOCK.get().validate(level, worldPosition.method_10074()) == null) {
            level.method_8501(worldPosition, class_2246.field_10441.method_9564());
            IXplatAbstractions.INSTANCE.sendToNear(level, worldPosition, new PacketBotaniaEffect(EffectType.ENCHANTER_DESTROY, (double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 0.5, (double)worldPosition.method_10260() + 0.5, new int[0]));
            level.method_8396(null, worldPosition, ModSounds.enchanterFade, class_3419.field_15245, 1.0f, 1.0f);
        }
        switch (self.stage) {
            case GATHER_ENCHANTS: {
                self.gatherEnchants();
                break;
            }
            case GATHER_MANA: {
                self.gatherMana(axis);
                break;
            }
            case DO_ENCHANT: {
                if (self.stageTicks < 100) break;
                for (class_1889 data : self.enchants) {
                    if (class_1890.method_8225((class_1887)data.field_9093, (class_1799)self.itemToEnchant) != 0) continue;
                    self.itemToEnchant.method_7978(data.field_9093, data.field_9094);
                }
                self.enchants.clear();
                self.manaRequired = -1;
                self.mana = 0;
                level.method_8427(worldPosition, ModBlocks.enchanter, 0, 0);
                self.advanceStage();
                break;
            }
            case RESET: {
                if (self.stageTicks < 20) break;
                self.advanceStage();
                break;
            }
        }
    }

    private void advanceStage() {
        switch (this.stage) {
            case IDLE: {
                this.stage = State.GATHER_ENCHANTS;
                break;
            }
            case GATHER_ENCHANTS: {
                this.stage = State.GATHER_MANA;
                break;
            }
            case GATHER_MANA: {
                this.stage = State.DO_ENCHANT;
                break;
            }
            case DO_ENCHANT: {
                this.stage = State.RESET;
                this.stage3EndTicks = this.stageTicks;
                break;
            }
            case RESET: {
                this.stage = State.IDLE;
                this.stage3EndTicks = 0;
            }
        }
        this.stageTicks = 0;
        this.sync();
    }

    public boolean method_11004(int event, int param) {
        switch (event) {
            case 0: {
                if (this.field_11863.field_9236) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_11863.method_8406((class_2394)data, (double)this.method_11016().method_10263() + Math.random() * 0.4 - 0.2, (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260() + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), ModSounds.enchanterEnchant, class_3419.field_15245, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.method_11004(event, param);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaRequired;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.manaRequired, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.manaRequired > 0;
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_MANA, this.mana);
        cmp.method_10569(TAG_MANA_REQUIRED, this.manaRequired);
        cmp.method_10569(TAG_STAGE, this.stage.ordinal());
        cmp.method_10569(TAG_STAGE_TICKS, this.stageTicks);
        cmp.method_10569(TAG_STAGE_3_END_TICKS, this.stage3EndTicks);
        class_2487 itemCmp = new class_2487();
        if (!this.itemToEnchant.method_7960()) {
            cmp.method_10566(TAG_ITEM, (class_2520)this.itemToEnchant.method_7953(itemCmp));
        }
        String enchStr = this.enchants.stream().map(e -> class_2378.field_11160.method_10221((Object)e.field_9093) + "=" + e.field_9094).collect(Collectors.joining(","));
        cmp.method_10582(TAG_ENCHANTS, enchStr);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.mana = cmp.method_10550(TAG_MANA);
        this.manaRequired = cmp.method_10550(TAG_MANA_REQUIRED);
        this.stage = State.values()[cmp.method_10550(TAG_STAGE)];
        this.stageTicks = cmp.method_10550(TAG_STAGE_TICKS);
        this.stage3EndTicks = cmp.method_10550(TAG_STAGE_3_END_TICKS);
        class_2487 itemCmp = cmp.method_10562(TAG_ITEM);
        this.itemToEnchant = class_1799.method_7915((class_2487)itemCmp);
        this.enchants.clear();
        String enchStr = cmp.method_10558(TAG_ENCHANTS);
        if (!enchStr.isEmpty()) {
            String[] enchTokens;
            for (String token : enchTokens = enchStr.split(",")) {
                try {
                    String[] entryTokens = token.split("=");
                    int lvl = Integer.parseInt(entryTokens[1]);
                    class_2378.field_11160.method_17966(new class_2960(entryTokens[0])).ifPresent(ench -> this.enchants.add(new class_1889(ench, lvl)));
                }
                catch (class_151 class_1512) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasEnchantAlready(class_1887 enchant) {
        for (class_1889 data : this.enchants) {
            if (data.field_9093 != enchant) continue;
            return true;
        }
        return false;
    }

    private boolean isEnchantmentValid(@Nullable class_1887 ench) {
        if (ench == null || !ench.method_8192(this.itemToEnchant)) {
            return false;
        }
        for (class_1889 data : this.enchants) {
            class_1887 otherEnch = data.field_9093;
            if (ench.method_8188(otherEnch)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static class_2350.class_2351 canEnchanterExist(class_1937 world, class_2338 pos) {
        class_2470 rot = MULTIBLOCK.get().validate(world, pos.method_10074());
        if (rot == null) {
            return null;
        }
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467, class_2470.field_11464 -> class_2350.class_2351.field_11051;
            case class_2470.field_11463, class_2470.field_11465 -> class_2350.class_2351.field_11048;
        };
    }

    @Override
    public boolean canAttachSpark(class_1799 stack) {
        return true;
    }

    @Override
    public IManaSpark getAttachedSpark() {
        List sparks = this.field_11863.method_8390(class_1297.class, new class_238((double)this.field_11867.method_10263(), (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 2), (double)(this.field_11867.method_10260() + 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
        if (sparks.size() == 1) {
            class_1297 e = (class_1297)sparks.get(0);
            return (IManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return this.stage == State.DO_ENCHANT;
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaRequired - this.getCurrentMana());
    }

    static {
        PYLON_LOCATIONS.put(class_2350.class_2351.field_11048, new class_2338[]{new class_2338(-5, 1, 0), new class_2338(5, 1, 0), new class_2338(-4, 1, 3), new class_2338(4, 1, 3), new class_2338(-4, 1, -3), new class_2338(4, 1, -3)});
        PYLON_LOCATIONS.put(class_2350.class_2351.field_11051, new class_2338[]{new class_2338(0, 1, -5), new class_2338(0, 1, 5), new class_2338(3, 1, -4), new class_2338(3, 1, 4), new class_2338(-3, 1, -4), new class_2338(-3, 1, 4)});
    }

    public static enum State {
        IDLE,
        GATHER_ENCHANTS,
        GATHER_MANA,
        DO_ENCHANT,
        RESET;

    }

    public static class WandHud
    implements IWandHUD {
        private final TileEnchanter enchanter;

        public WandHud(TileEnchanter enchanter) {
            this.enchanter = enchanter;
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            if (this.enchanter.manaRequired > 0 && !this.enchanter.itemToEnchant.method_7960()) {
                int x = mc.method_22683().method_4486() / 2 + 20;
                int y = mc.method_22683().method_4502() / 2 - 8;
                RenderHelper.renderProgressPie(ms, x, y, (float)this.enchanter.mana / (float)this.enchanter.manaRequired, this.enchanter.itemToEnchant);
            }
        }
    }
}

