/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.WispParticleData;

public abstract class SubTileFluidGenerator
extends TileEntityGeneratingFlower {
    private static final String TAG_BURN_TIME = "burnTime";
    public static final String TAG_COOLDOWN = "cooldown";
    private static final class_2338[] OFFSETS = new class_2338[]{new class_2338(0, 0, 1), new class_2338(0, 0, -1), new class_2338(1, 0, 0), new class_2338(-1, 0, 0), new class_2338(-1, 0, 1), new class_2338(-1, 0, -1), new class_2338(1, 0, 1), new class_2338(1, 0, -1)};
    public static final int DECAY_TIME = 72000;
    private int burnTime;
    private int cooldown;
    private final class_3494<class_3611> consumedFluid;
    private final int startBurnTime;
    private final int manaPerTick;
    private final int maxCooldown;

    protected SubTileFluidGenerator(class_2591<?> type, class_2338 pos, class_2680 state, class_3494<class_3611> consumedFluid, int startBurnTime, int manaPerTick, int maxCooldown) {
        super(type, pos, state);
        this.consumedFluid = consumedFluid;
        this.startBurnTime = startBurnTime;
        this.manaPerTick = manaPerTick;
        this.maxCooldown = maxCooldown;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.1f, 0.1f, 0.1f, 1.0f);
                this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 30.0f, 0.0);
            }
        }
        if (!this.method_10997().field_9236 && this.burnTime > 0 && this.ticksExisted % this.getGenerationDelay() == 0) {
            this.addMana(this.manaPerTick);
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana() && !this.method_10997().field_9236) {
                List<class_2338> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (class_2338 offset : offsets) {
                    class_2338 pos = this.getEffectivePos().method_10081((class_2382)offset);
                    class_2680 bstate = this.method_10997().method_8320(pos);
                    class_3610 fstate = this.method_10997().method_8316(pos);
                    if (!fstate.method_15767(this.consumedFluid) || !fstate.method_15771()) continue;
                    if (this.consumedFluid != class_3486.field_15517) {
                        this.method_10997().method_8501(pos, class_2246.field_10124.method_9564());
                    } else {
                        int waterAround = 0;
                        for (class_2350 dir : class_2350.values()) {
                            if (!this.method_10997().method_8316(pos.method_10093(dir)).method_15767(this.consumedFluid)) continue;
                            ++waterAround;
                        }
                        if (waterAround < 2) {
                            class_2248 class_22482 = bstate.method_26204();
                            if (class_22482 instanceof class_2263) {
                                class_2263 bucketPickup = (class_2263)class_22482;
                                bucketPickup.method_9700((class_1936)this.method_10997(), pos, bstate);
                            } else {
                                this.method_10997().method_8501(pos, class_2246.field_10124.method_9564());
                            }
                        }
                    }
                    if (this.cooldown == 0) {
                        this.burnTime += this.startBurnTime;
                    } else {
                        this.cooldown = this.maxCooldown;
                    }
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.method_10997().field_9229.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
            if (this.burnTime == 0) {
                this.cooldown = this.maxCooldown;
                this.sync();
            }
        }
    }

    public int getGenerationDelay() {
        return 1;
    }

    public abstract void doBurnParticles();

    public abstract void playSound();

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_BURN_TIME, this.burnTime);
        cmp.method_10569(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.method_10550(TAG_BURN_TIME);
        this.cooldown = cmp.method_10550(TAG_COOLDOWN);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }
}

