/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.subtile.functional.SubTileHopperhock;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class SubTileRannuncarpus
extends TileEntityFunctionalFlower
implements IWandable {
    private static final int PICKUP_RANGE = 2;
    private static final int PICKUP_RANGE_Y = 3;
    private static final int RANGE_PLACE_MANA = 8;
    private static final int RANGE_PLACE = 6;
    private static final int RANGE_PLACE_Y = 6;
    private static final int RANGE_PLACE_MANA_MINI = 3;
    private static final int RANGE_PLACE_MINI = 2;
    private static final int RANGE_PLACE_Y_MINI = 2;
    private static final String TAG_STATE_SENSITIVE = "stateSensitive";
    private boolean stateSensitive = false;

    protected SubTileRannuncarpus(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SubTileRannuncarpus(class_2338 pos, class_2680 state) {
        this(ModSubtiles.RANNUNCARPUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236 || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            List items = this.method_10997().method_18467(class_1542.class, new class_238(this.getEffectivePos().method_10069(-2, -3, -2), this.getEffectivePos().method_10069(3, 4, 3)));
            List<class_1799> filter = SubTileHopperhock.getFilterForInventory(this.method_10997(), this.getFilterPos(), false);
            for (class_1542 item : items) {
                class_2338 coords;
                class_1799 stack;
                if (!DelayHelper.canInteractWith(this, item) || !SubTileHopperhock.canAcceptItem(stack = item.method_6983(), filter, 0)) continue;
                class_1792 stackItem = stack.method_7909();
                class_2960 id = class_2378.field_11142.method_10221((Object)stackItem);
                if (BotaniaConfig.common().rannuncarpusModBlacklist().contains(id.method_12836()) || BotaniaConfig.common().rannuncarpusItemBlacklist().contains(id.toString()) || !(stackItem instanceof class_1747) && !(stackItem instanceof IFlowerPlaceable) || (coords = this.getCandidatePosition(this.method_10997().field_9229)) == null) continue;
                class_3965 ray = new class_3965(new class_243((double)coords.method_10263() + 0.5, (double)(coords.method_10264() + 1), (double)coords.method_10260() + 0.5), class_2350.field_11036, coords, false);
                RannuncarpusPlaceContext ctx = new RannuncarpusPlaceContext(this.method_10997(), stack, ray, this.field_11867);
                boolean success = false;
                if (stackItem instanceof IFlowerPlaceable) {
                    IFlowerPlaceable flowerPlaceable = (IFlowerPlaceable)stackItem;
                    success = flowerPlaceable.tryPlace(this, ctx);
                }
                if (!success && stackItem instanceof class_1747) {
                    class_1747 blockItem = (class_1747)stackItem;
                    success = blockItem.method_7712((class_1750)ctx).method_23665();
                }
                if (!success) continue;
                if (BotaniaConfig.common().blockBreakParticles()) {
                    class_2680 state = this.method_10997().method_8320(ctx.method_8037());
                    this.method_10997().method_20290(2001, coords, class_2248.method_9507((class_2680)state));
                }
                if (this.getMana() > 1) {
                    this.addMana(-1);
                }
                return;
            }
        }
    }

    private class_2338 getFilterPos() {
        return this.getEffectivePos().method_10087(this.isFloating() ? 1 : 2);
    }

    public class_2680 getUnderlyingBlock() {
        return this.method_10997().method_8320(this.getFilterPos());
    }

    @Nullable
    private class_2338 getCandidatePosition(Random rand) {
        int rangePlace = this.getPlaceRange();
        int rangePlaceY = this.getVerticalPlaceRange();
        class_2338 center = this.getEffectivePos();
        class_2680 filter = this.getUnderlyingBlock();
        ArrayList<class_2338> ret = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(-rangePlace, -rangePlaceY, -rangePlace), (class_2338)center.method_10069(rangePlace, rangePlaceY, rangePlace))) {
            class_2680 state = this.method_10997().method_8320(pos);
            class_2680 up = this.method_10997().method_8320(pos.method_10084());
            boolean matches = this.stateSensitive ? state == filter : state.method_27852(filter.method_26204());
            if (!matches || !up.method_26215() && !up.method_26207().method_15800()) continue;
            ret.add(pos.method_10062());
        }
        return ret.isEmpty() ? null : (class_2338)ret.get(rand.nextInt(ret.size()));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.stateSensitive = cmp.method_10545(TAG_STATE_SENSITIVE) ? cmp.method_10577(TAG_STATE_SENSITIVE) : true;
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10556(TAG_STATE_SENSITIVE, this.stateSensitive);
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.stateSensitive = !this.stateSensitive;
            this.method_5431();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getPlaceRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        if (this.getPlaceRange() == 2) {
            return null;
        }
        return new RadiusDescriptor.Square(this.getEffectivePos(), 2);
    }

    public int getPlaceRange() {
        return this.getMana() > 0 ? 8 : 6;
    }

    public int getVerticalPlaceRange() {
        return 6;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 16757375;
    }

    private static class RannuncarpusPlaceContext
    extends class_1750 {
        private final class_2350[] lookDirs;
        private final float placementYaw;

        public RannuncarpusPlaceContext(class_1937 world, class_1799 stack, class_3965 rtr, class_2338 flowerPos) {
            super(world, null, class_1268.field_5808, stack, rtr);
            int dx = rtr.method_17777().method_10263() - flowerPos.method_10263();
            int dy = rtr.method_17777().method_10264() - flowerPos.method_10264();
            int dz = rtr.method_17777().method_10260() - flowerPos.method_10260();
            class_2350 xClosest = dx >= 0 ? class_2350.field_11034 : class_2350.field_11039;
            class_2350 yClosest = dy >= 0 ? class_2350.field_11036 : class_2350.field_11033;
            class_2350 zClosest = dz >= 0 ? class_2350.field_11035 : class_2350.field_11043;
            List<class_2350> directions = RannuncarpusPlaceContext.sortThree(xClosest, yClosest, zClosest, Math.abs(dx), Math.abs(dy), Math.abs(dz));
            class_2350 first = directions.get(0);
            class_2350 second = directions.get(1);
            class_2350 third = directions.get(2);
            this.lookDirs = new class_2350[]{first, second, third, third.method_10153(), second.method_10153(), first.method_10153()};
            this.placementYaw = (float)(-class_3532.method_15349((double)dx, (double)dz) * 180.0 / Math.PI);
        }

        private static <T> List<T> sortThree(T a, T b, T c, int aInt, int bInt, int cInt) {
            if (aInt >= bInt) {
                if (bInt >= cInt) {
                    return ImmutableList.of(a, b, c);
                }
                return cInt >= aInt ? ImmutableList.of(c, a, b) : ImmutableList.of(a, c, b);
            }
            if (bInt >= cInt) {
                return cInt >= aInt ? ImmutableList.of(b, c, a) : ImmutableList.of(b, a, c);
            }
            return ImmutableList.of(c, b, a);
        }

        @Nonnull
        public class_2350 method_7715() {
            return this.method_7718()[0];
        }

        @Nonnull
        public class_2350[] method_7718() {
            return this.lookDirs;
        }

        @Nonnull
        public class_2350 method_8042() {
            return this.method_7715().method_10166().method_10179() ? this.method_7715() : this.method_7718()[1];
        }

        public float method_8044() {
            return this.placementYaw;
        }
    }

    public static class Mini
    extends SubTileRannuncarpus {
        public Mini(class_2338 pos, class_2680 state) {
            super(ModSubtiles.RANNUNCARPUS_CHIBI, pos, state);
        }

        @Override
        public int getPlaceRange() {
            return this.getMana() > 0 ? 3 : 2;
        }

        @Override
        public int getVerticalPlaceRange() {
            return 2;
        }
    }

    public static class WandHud
    extends TileEntityFunctionalFlower.FunctionalWandHud<SubTileRannuncarpus> {
        public WandHud(SubTileRannuncarpus flower) {
            super(flower);
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            super.renderHUD(ms, mc);
            class_2680 filter = ((SubTileRannuncarpus)this.flower).getUnderlyingBlock();
            class_1799 recieverStack = new class_1799((class_1935)filter.method_26204());
            int color = ((SubTileRannuncarpus)this.flower).getColor();
            if (!recieverStack.method_7960()) {
                class_2561 stackName = recieverStack.method_7964();
                int width = 16 + mc.field_1772.method_27525((class_5348)stackName) / 2;
                int x = mc.method_22683().method_4486() / 2 - width;
                int y = mc.method_22683().method_4502() / 2 + 30;
                mc.field_1772.method_30881(ms, stackName, (float)(x + 20), (float)(y + 5), color);
                mc.method_1480().method_4023(recieverStack, x, y);
                String mode = class_1074.method_4662((String)("botaniamisc.rannuncarpus." + (((SubTileRannuncarpus)this.flower).stateSensitive ? "state_sensitive" : "state_insensitive")), (Object[])new Object[0]);
                x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(mode) / 2;
                y = mc.method_22683().method_4502() / 2 + 50;
                mc.field_1772.method_1720(ms, mode, (float)x, (float)y, class_124.field_1068.method_532().intValue());
            }
        }
    }
}

