/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.xplat.BotaniaConfig;

public class SubTilePureDaisy
extends TileEntitySpecialFlower {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int RECIPE_COMPLETE_EVENT = 0;
    private static final class_2338[] POSITIONS = new class_2338[]{new class_2338(-1, 0, -1), new class_2338(-1, 0, 0), new class_2338(-1, 0, 1), new class_2338(0, 0, 1), new class_2338(1, 0, 1), new class_2338(1, 0, 0), new class_2338(1, 0, -1), new class_2338(0, 0, -1)};
    private int positionAt = 0;
    private final int[] prevTicksRemaining = new int[POSITIONS.length];
    private final int[] ticksRemaining = new int[POSITIONS.length];

    public SubTilePureDaisy(class_2338 pos, class_2680 state) {
        super(ModSubtiles.PURE_DAISY, pos, state);
        Arrays.fill(this.prevTicksRemaining, -1);
        Arrays.fill(this.ticksRemaining, -1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236) {
            for (int i = 0; i < POSITIONS.length; ++i) {
                if (this.ticksRemaining[i] <= 0) continue;
                class_2338 coords = this.getEffectivePos().method_10081((class_2382)POSITIONS[i]);
                SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), 1.0f, 1.0f, 1.0f, 5);
                this.field_11863.method_8406((class_2394)data, (double)coords.method_10263() + Math.random(), (double)coords.method_10264() + Math.random(), (double)coords.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        class_2338 acoords = POSITIONS[this.positionAt];
        class_2338 coords = this.getEffectivePos().method_10081((class_2382)acoords);
        class_1937 world = this.method_10997();
        if (!world.method_22347(coords)) {
            world.method_16107().method_15396("findRecipe");
            IPureDaisyRecipe recipe = this.findRecipe(coords);
            world.method_16107().method_15407();
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.ticksRemaining[this.positionAt] = -1;
                    if (recipe.set(world, coords, this)) {
                        if (BotaniaConfig.common().blockBreakParticles()) {
                            this.method_10997().method_20290(2001, coords, class_2248.method_9507((class_2680)recipe.getOutputState()));
                        }
                        this.method_10997().method_8427(this.method_11016(), this.method_11010().method_26204(), 0, this.positionAt);
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        } else {
            this.ticksRemaining[this.positionAt] = -1;
        }
        if (!Arrays.equals(this.ticksRemaining, this.prevTicksRemaining)) {
            this.method_5431();
            this.sync();
            System.arraycopy(this.ticksRemaining, 0, this.prevTicksRemaining, 0, POSITIONS.length);
        }
    }

    @Nullable
    private IPureDaisyRecipe findRecipe(class_2338 coords) {
        class_2680 state = this.method_10997().method_8320(coords);
        for (class_1860 recipe : ModRecipeTypes.getRecipes(this.field_11863, ModRecipeTypes.PURE_DAISY_TYPE).values()) {
            IPureDaisyRecipe daisyRecipe;
            if (!(recipe instanceof IPureDaisyRecipe) || !(daisyRecipe = (IPureDaisyRecipe)recipe).matches(this.method_10997(), coords, this, state)) continue;
            return daisyRecipe;
        }
        return null;
    }

    public boolean method_11004(int type, int param) {
        switch (type) {
            case 0: {
                if (this.method_10997().field_9236) {
                    class_2338 coords = this.getEffectivePos().method_10081((class_2382)POSITIONS[param]);
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.method_10263() + Math.random();
                        double y = (double)coords.method_10264() + Math.random() + 0.5;
                        double z = (double)coords.method_10260() + Math.random();
                        WispParticleData data = WispParticleData.wisp((float)Math.random() / 2.0f, 1.0f, 1.0f, 1.0f);
                        this.method_10997().method_8406((class_2394)data, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
        }
        return super.method_11004(type, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.positionAt = cmp.method_10550(TAG_POSITION);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            this.ticksRemaining[i] = cmp.method_10550(TAG_TICKS_REMAINING + i);
        }
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.method_10569(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }
}

