/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1160;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_809;
import net.minecraft.class_827;
import net.minecraft.class_918;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockTinyPotato;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.client.AccessorModelManager;
import vazkii.botania.xplat.IClientXplatAbstractions;

public class RenderTileTinyPotato
implements class_827<TileTinyPotato> {
    public static final String DEFAULT = "default";
    public static final String HALLOWEEN = "halloween";
    private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
    private final class_776 blockRenderDispatcher;

    public RenderTileTinyPotato(class_5614.class_5615 ctx) {
        this.blockRenderDispatcher = ctx.method_32141();
    }

    private static boolean matches(String name, String match) {
        return name.equals(match) || name.startsWith(match + " ");
    }

    private static String removeFromFront(String name, String match) {
        return name.substring(match.length()).trim();
    }

    public static class_1087 getModelFromDisplayName(class_2561 displayName) {
        String name = displayName.getString().trim().toLowerCase(Locale.ROOT);
        if (RenderTileTinyPotato.matches(name, "enchanted")) {
            name = RenderTileTinyPotato.removeFromFront(name, "enchanted");
        }
        return RenderTileTinyPotato.getModel(name);
    }

    private static class_1087 getModel(String name) {
        class_1092 bmm = class_310.method_1551().method_1554();
        Map<class_2960, class_1087> mm = ((AccessorModelManager)bmm).getBakedRegistry();
        class_1087 missing = bmm.method_4744();
        class_2960 location = RenderTileTinyPotato.taterLocation(name);
        class_1087 model = mm.get(location);
        if (model == null) {
            if (ClientProxy.dootDoot) {
                return mm.getOrDefault(RenderTileTinyPotato.taterLocation(HALLOWEEN), missing);
            }
            return mm.getOrDefault(RenderTileTinyPotato.taterLocation(DEFAULT), missing);
        }
        return model;
    }

    private static class_2960 taterLocation(String name) {
        return ResourceLocationHelper.prefix("tiny_potato/" + RenderTileTinyPotato.normalizeName(name));
    }

    private static String normalizeName(String name) {
        return ESCAPED.matcher(name).replaceAll("_");
    }

    public void render(@Nonnull TileTinyPotato potato, float partialTicks, class_4587 ms, @Nonnull class_4597 buffers, int light, int overlay) {
        boolean render;
        ms.method_22903();
        String name = potato.name.getString().toLowerCase(Locale.ROOT).trim();
        boolean enchanted = RenderTileTinyPotato.matches(name, "enchanted");
        if (enchanted) {
            name = RenderTileTinyPotato.removeFromFront(name, "enchanted");
        }
        class_1921 layer = class_4722.method_24076();
        class_1087 model = RenderTileTinyPotato.getModel(name);
        ms.method_22904(0.5, 0.0, 0.5);
        class_2350 potatoFacing = (class_2350)potato.method_11010().method_11654((class_2769)class_2741.field_12481);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                rotY = 180.0f;
                break;
            }
            case field_11043: {
                break;
            }
            case field_11034: {
                rotY = 90.0f;
                break;
            }
            case field_11039: {
                rotY = 270.0f;
            }
        }
        ms.method_22907(class_1160.field_20704.method_23214(rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI)) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        float wiggle = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 0.05f;
        ms.method_22904((double)wiggle, (double)up, 0.0);
        ms.method_22907(class_1160.field_20707.method_23214(rotZ));
        boolean bl = render = !name.equals("mami") && !name.equals("soaryn") && (!name.equals("eloraam") || jump == 0.0f);
        if (render) {
            ms.method_22903();
            ms.method_22904(-0.5, 0.0, -0.5);
            class_4588 buffer = class_918.method_23181((class_4597)buffers, (class_1921)layer, (boolean)true, (boolean)enchanted);
            this.renderModel(ms, buffer, light, overlay, model);
            ms.method_22909();
        }
        ms.method_22904(0.0, 1.5, 0.0);
        ms.method_22903();
        ms.method_22907(class_1160.field_20707.method_23214(180.0f));
        this.renderItems(potato, potatoFacing, name, partialTicks, ms, buffers, light, overlay);
        ms.method_22903();
        IClientXplatAbstractions.INSTANCE.fireRenderTinyPotato(potato, potato.name, partialTicks, ms, buffers, light, overlay);
        ms.method_22909();
        ms.method_22909();
        ms.method_22907(class_1160.field_20707.method_23214(-rotZ));
        ms.method_22907(class_1160.field_20704.method_23214(-rotY));
        this.renderName(potato, name, ms, buffers, light);
        ms.method_22909();
    }

    private void renderName(TileTinyPotato potato, String name, class_4587 ms, class_4597 buffers, int light) {
        class_310 mc = class_310.method_1551();
        class_239 pos = mc.field_1765;
        if (class_310.method_1498() && !name.isEmpty() && pos != null && pos.method_17783() == class_239.class_240.field_1332 && potato.method_11016().equals((Object)((class_3965)pos).method_17777())) {
            ms.method_22903();
            ms.method_22904(0.0, (double)-0.6f, 0.0);
            ms.method_22907(mc.method_1561().method_24197());
            float f1 = 0.02666667f;
            ms.method_22905(-f1, -f1, f1);
            int halfWidth = mc.field_1772.method_1727(potato.name.getString()) / 2;
            float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.field_1772.method_30882(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.method_23760().method_23761(), buffers, true, opacityRGB, light);
            mc.field_1772.method_30882(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.method_23760().method_23761(), buffers, false, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.method_22904(0.0, 14.0, 0.0);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.field_1772.method_1727(str) / 2;
                mc.field_1772.method_27521(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.method_23760().method_23761(), buffers, true, opacityRGB, light);
                mc.field_1772.method_27521(str, (float)(-halfWidth), 0.0f, -1, false, ms.method_23760().method_23761(), buffers, true, 0, light);
            }
            ms.method_22909();
        }
    }

    private void renderItems(TileTinyPotato potato, class_2350 facing, String name, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        ms.method_22903();
        ms.method_22907(class_1160.field_20707.method_23214(180.0f));
        ms.method_22904(0.0, -1.0, 0.0);
        float s = 0.2857143f;
        ms.method_22905(s, s, s);
        for (int i = 0; i < potato.inventorySize(); ++i) {
            class_1799 stack = potato.getItemHandler().method_5438(i);
            if (stack.method_7960()) continue;
            ms.method_22903();
            class_2350 side = class_2350.values()[i];
            if (side.method_10166() != class_2350.class_2351.field_11052) {
                float sideAngle = side.method_10144() - facing.method_10144();
                side = class_2350.method_10150((double)sideAngle);
            }
            boolean block = stack.method_7909() instanceof class_1747;
            boolean mySon = stack.method_7909() instanceof ItemBlockTinyPotato;
            switch (side) {
                case field_11036: {
                    if (mySon) {
                        ms.method_22904(0.0, (double)0.6f, 0.5);
                    } else if (block) {
                        ms.method_22904(0.0, (double)0.3f, 0.5);
                    }
                    ms.method_22904(0.0, -0.5, (double)-0.4f);
                    break;
                }
                case field_11033: {
                    ms.method_22904(0.0, (double)-2.3f, (double)-0.88f);
                    if (mySon) {
                        ms.method_22904(0.0, (double)0.65f, (double)0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.method_22904(0.0, 1.0, (double)0.6f);
                    break;
                }
                case field_11043: {
                    ms.method_22904(0.0, (double)-1.9f, (double)0.02f);
                    if (mySon) {
                        ms.method_22904(0.0, 1.0, (double)0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.method_22904(0.0, 1.0, (double)0.6f);
                    break;
                }
                case field_11035: {
                    ms.method_22904(0.0, (double)-1.6f, (double)-0.89f);
                    if (mySon) {
                        ms.method_22904(0.0, (double)1.4f, 0.5);
                        break;
                    }
                    if (!block) break;
                    ms.method_22904(0.0, 1.0, 0.5);
                    break;
                }
                case field_11034: {
                    if (mySon) {
                        ms.method_22904((double)-0.4f, (double)0.65f, 0.0);
                    } else if (block) {
                        ms.method_22904((double)-0.4f, (double)0.8f, 0.0);
                    } else {
                        ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
                    }
                    ms.method_22904((double)-0.3f, (double)-1.9f, (double)0.04f);
                    break;
                }
                case field_11039: {
                    if (mySon) {
                        ms.method_22904(1.0, (double)0.65f, 1.0);
                    } else if (block) {
                        ms.method_22904(1.0, (double)0.8f, 1.0);
                    } else {
                        ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
                    }
                    ms.method_22904((double)-0.3f, (double)-1.9f, (double)-0.92f);
                }
            }
            if (mySon) {
                ms.method_22905(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.method_22905(0.5f, 0.5f, 0.5f);
            }
            if (block && side == class_2350.field_11043) {
                ms.method_22907(class_1160.field_20705.method_23214(180.0f));
            }
            this.renderItem(ms, buffers, light, overlay, stack);
            ms.method_22909();
        }
        ms.method_22909();
        ms.method_22903();
        if (!name.isEmpty()) {
            ContributorList.firstStart();
            float scale = 0.25f;
            ms.method_22904(0.0, 1.0, 0.0);
            ms.method_22905(scale, scale, scale);
            switch (name) {
                case "phi": 
                case "vazkii": {
                    ms.method_22903();
                    ms.method_22904(-0.15, 0.1, 0.4);
                    ms.method_22907(class_1160.field_20705.method_23214(90.0f));
                    ms.method_22907(new class_1160(1.0f, 0.0f, 1.0f).method_23214(20.0f));
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.phiFlowerModel);
                    ms.method_22909();
                    if (!name.equals("vazkii")) break;
                    ms.method_22905(1.25f, 1.25f, 1.25f);
                    ms.method_22907(class_1160.field_20703.method_23214(180.0f));
                    ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
                    ms.method_22904(0.2, -1.25, 0.0);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.nerfBatModel);
                    break;
                }
                case "haighyorkie": {
                    ms.method_22905(1.25f, 1.25f, 1.25f);
                    ms.method_22907(class_1160.field_20707.method_23214(180.0f));
                    ms.method_22907(class_1160.field_20705.method_23214(-90.0f));
                    ms.method_22904(-0.5, (double)-1.2f, (double)-0.075f);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousModels.INSTANCE.goldfishModel);
                    break;
                }
                case "martysgames": 
                case "marty": {
                    ms.method_22905(0.7f, 0.7f, 0.7f);
                    ms.method_22907(class_1160.field_20707.method_23214(180.0f));
                    ms.method_22904((double)-0.3f, (double)-2.7f, (double)-1.2f);
                    ms.method_22907(class_1160.field_20707.method_23214(15.0f));
                    this.renderItem(ms, buffers, light, overlay, new class_1799((class_1935)ModItems.infiniteFruit, 1).method_7977((class_2561)new class_2585("das boot")));
                    break;
                }
                case "jibril": {
                    ms.method_22905(1.5f, 1.5f, 1.5f);
                    ms.method_22904(0.0, (double)0.8f, 0.0);
                    ItemFlightTiara.ClientLogic.renderHalo(null, null, ms, buffers, partialTicks);
                    break;
                }
                case "kingdaddydmac": {
                    ms.method_22905(0.5f, 0.5f, 0.5f);
                    ms.method_22907(class_1160.field_20707.method_23214(180.0f));
                    ms.method_22907(class_1160.field_20705.method_23214(90.0f));
                    ms.method_22903();
                    ms.method_22904(0.0, -2.5, (double)0.65f);
                    class_1799 ring = new class_1799((class_1935)ModItems.manaRing);
                    this.renderItem(ms, buffers, light, overlay, ring);
                    ms.method_22904(0.0, 0.0, -4.0);
                    this.renderItem(ms, buffers, light, overlay, ring);
                    ms.method_22909();
                    ms.method_22904(1.5, -4.0, -2.5);
                    this.renderBlock(ms, buffers, light, overlay, class_2246.field_10183);
                    break;
                }
                default: {
                    class_1799 icon = ContributorList.getFlower(name);
                    if (icon.method_7960()) break;
                    ms.method_22907(class_1160.field_20703.method_23214(180.0f));
                    ms.method_22907(class_1160.field_20705.method_23214(180.0f));
                    ms.method_22904(0.0, -0.75, -0.5);
                    class_310.method_1551().method_1480().method_23178(icon, class_809.class_811.field_4316, light, overlay, ms, buffers, 0);
                }
            }
        }
        ms.method_22909();
    }

    private void renderModel(class_4587 ms, class_4597 buffers, int light, int overlay, class_1087 model) {
        this.renderModel(ms, buffers.getBuffer(class_4722.method_24076()), light, overlay, model);
    }

    private void renderModel(class_4587 ms, class_4588 buffer, int light, int overlay, class_1087 model) {
        this.blockRenderDispatcher.method_3350().method_3367(ms.method_23760(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(class_4587 ms, class_4597 buffers, int light, int overlay, class_1799 stack) {
        class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4316, light, overlay, ms, buffers, 0);
    }

    private void renderBlock(class_4587 ms, class_4597 buffers, int light, int overlay, class_2248 block) {
        this.blockRenderDispatcher.method_3353(block.method_9564(), ms, buffers, light, overlay);
    }
}

