/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5250;
import net.minecraft.class_557;
import net.minecraft.class_5602;
import net.minecraft.class_809;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.xplat.BotaniaConfig;

public class RenderLexicon {
    private static class_557 model = null;
    private static final boolean SHOULD_MISSPELL = Math.random() < 0.004;
    public static final class_4730 TEXTURE = new class_4730(class_1723.field_21668, new class_2960("botania:model/lexicon_default"));
    public static final class_4730 ELVEN_TEXTURE = new class_4730(class_1723.field_21668, new class_2960("botania:model/lexicon_elven"));
    private static final String[] QUOTES = new String[]{"\"Neat!\" - Direwolf20", "\"It's pretty ledge.\" - Haighyorkie", "\"I don't really like it.\" - CrustyMustard", "\"It's a very thinky mod.\" - AdamG3691", "\"You must craft the tiny potato.\" - TheFractangle", "\"Vazkii did a thing.\" - cpw"};
    private static final String[] MISSPELLINGS = new String[]{"Bonito", "Bonita", "Bonitia", "Botnaia", "Bontonio", "Botnia", "Bonitaaaaaaaaaa", "Botonio", "Botonia", "Botnetia", "Banana", "Brotania", "Botanica", "Boat", "Batania", "Bosnia"};
    private static int quote = -1;
    private static int misspelling = -1;

    private static class_557 getModel() {
        if (model == null) {
            model = new class_557(class_310.method_1551().method_31974().method_32072(class_5602.field_27685));
        }
        return model;
    }

    public static boolean renderHand(class_1799 stack, class_809.class_811 type, boolean leftHanded, class_4587 ms, class_4597 buffers, int light) {
        if (!BotaniaConfig.client().lexicon3dModel() || !type.method_29998() || stack.method_7960() || !stack.method_31574((class_1792)ModItems.lexicon)) {
            return false;
        }
        try {
            RenderLexicon.doRender(stack, leftHanded, ms, buffers, light, ClientTickHandler.partialTicks);
            return true;
        }
        catch (Throwable throwable) {
            BotaniaAPI.LOGGER.warn("Failed to render lexicon", throwable);
            return false;
        }
    }

    private static void doRender(class_1799 stack, boolean leftHanded, class_4587 ms, class_4597 buffers, int light, float partialTicks) {
        class_310 mc = class_310.method_1551();
        ms.method_22903();
        float ticks = ClientTickHandler.ticksWithLexicaOpen;
        if (ticks > 0.0f && ticks < 10.0f) {
            ticks = ItemLexicon.isOpen() ? (ticks += partialTicks) : (ticks -= partialTicks);
        }
        if (!leftHanded) {
            ms.method_22904((double)(0.3f + 0.02f * ticks), (double)(0.125f + 0.01f * ticks), (double)(-0.2f - 0.035f * ticks));
            ms.method_22907(class_1160.field_20705.method_23214(180.0f + ticks * 6.0f));
        } else {
            ms.method_22904((double)(0.1f - 0.02f * ticks), (double)(0.125f + 0.01f * ticks), (double)(-0.2f - 0.035f * ticks));
            ms.method_22907(class_1160.field_20705.method_23214(200.0f + ticks * 10.0f));
        }
        ms.method_22907(class_1160.field_20707.method_23214(-0.3f + ticks * 2.85f));
        float opening = class_3532.method_15363((float)(ticks / 12.0f), (float)0.0f, (float)1.0f);
        float pageFlipTicks = ClientTickHandler.pageFlipTicks;
        if (pageFlipTicks > 0.0f) {
            pageFlipTicks -= ClientTickHandler.partialTicks;
        }
        float pageFlip = pageFlipTicks / 5.0f;
        float leftPageAngle = class_3532.method_22450((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
        float rightPageAngle = class_3532.method_22450((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
        class_557 model = RenderLexicon.getModel();
        model.method_17073(ClientTickHandler.total(), class_3532.method_15363((float)leftPageAngle, (float)0.0f, (float)1.0f), class_3532.method_15363((float)rightPageAngle, (float)0.0f, (float)1.0f), opening);
        class_4730 mat = ItemLexicon.isElven(stack) ? ELVEN_TEXTURE : TEXTURE;
        class_4588 buffer = mat.method_24145(buffers, class_1921::method_23572);
        model.method_2828(ms, buffer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (ticks < 3.0f) {
            class_327 font = class_310.method_1551().field_1772;
            ms.method_22907(class_1160.field_20707.method_23214(180.0f));
            ms.method_22904((double)-0.3f, (double)-0.24f, (double)-0.07f);
            ms.method_22905(0.003f, 0.003f, -0.003f);
            if (misspelling == -1 && mc.field_1687 != null) {
                misspelling = mc.field_1687.field_9229.nextInt(MISSPELLINGS.length);
            }
            String title = ItemLexicon.getTitle(stack).getString();
            if (SHOULD_MISSPELL) {
                title = title.replaceAll("Botania", MISSPELLINGS[misspelling]);
            }
            font.method_27521(font.method_27523(title, 80), 0.0f, 0.0f, 14063360, false, ms.method_23760().method_23761(), buffers, false, 0, light);
            ms.method_22904(0.0, 10.0, 0.0);
            ms.method_22905(0.6f, 0.6f, 0.6f);
            class_5250 edition = ItemLexicon.getEdition().method_27661().method_27695(new class_124[]{class_124.field_1056, class_124.field_1067});
            font.method_30882((class_2561)edition, 0.0f, 0.0f, 10514688, false, ms.method_23760().method_23761(), buffers, false, 0, light);
            if (quote == -1 && mc.field_1687 != null) {
                quote = mc.field_1687.field_9229.nextInt(QUOTES.length);
            }
            String quoteStr = QUOTES[quote];
            ms.method_22904(-5.0, 15.0, 0.0);
            RenderLexicon.renderText(0, 0, 140, 0, 7995282, quoteStr, ms.method_23760().method_23761(), buffers, light);
            ms.method_22904(8.0, 110.0, 0.0);
            String blurb = class_1074.method_4662((String)"botaniamisc.lexiconcover0", (Object[])new Object[0]);
            font.method_27521(blurb, 0.0f, 0.0f, 7995282, false, ms.method_23760().method_23761(), buffers, false, 0, light);
            ms.method_22904(0.0, 10.0, 0.0);
            String blurb2 = class_124.field_1073 + class_124.field_1056 + class_1074.method_4662((String)"botaniamisc.lexiconcover1", (Object[])new Object[0]);
            font.method_27521(blurb2, 0.0f, 0.0f, 7995282, false, ms.method_23760().method_23761(), buffers, false, 0, light);
            ms.method_22904(0.0, -30.0, 0.0);
            String authorTitle = class_1074.method_4662((String)"botaniamisc.lexiconcover2", (Object[])new Object[0]);
            int len = font.method_1727(authorTitle);
            font.method_27521(authorTitle, 58.0f - (float)len / 2.0f, -8.0f, 14063360, false, ms.method_23760().method_23761(), buffers, false, 0, light);
        }
        ms.method_22909();
    }

    private static void renderText(int x, int y, int width, int paragraphSize, int color, String unlocalizedText, class_1159 matrix, class_4597 buffers, int light) {
        x += 2;
        y += 10;
        width -= 4;
        class_327 font = class_310.method_1551().field_1772;
        String text = class_1074.method_4662((String)unlocalizedText, (Object[])new Object[0]).replaceAll("&", "\u00a7");
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        for (String s : textEntries) {
            String[] tokens;
            ArrayList<CallSite> words = new ArrayList<CallSite>();
            Object lineStr = "";
            for (String token : tokens = s.split(" ")) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = (String)lineStr + spaced;
                String controlCodes = RenderLexicon.toControlCodes(RenderLexicon.getControlCodes(prev));
                if (font.method_1727((String)lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add((CallSite)((Object)(controlCodes + token)));
            }
            if (!((String)lineStr).isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
        }
        for (List list : lines) {
            int xi = x;
            int spacing = 4;
            for (String s : list) {
                int extra = 0;
                font.method_27521(s, (float)xi, (float)y, color, false, matrix, buffers, false, 0, light);
                xi += font.method_1727(s) + spacing + extra;
            }
            y += list.isEmpty() ? paragraphSize : 10;
        }
    }

    private static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    private static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

