/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.TileEntityBindableSpecialFlower;

public abstract class TileEntityFunctionalFlower
extends TileEntityBindableSpecialFlower<IManaPool> {
    private static final class_2960 POOL_ID = new class_2960("botania", "mana_pool");
    public static final int LINK_RANGE = 10;
    private static final String TAG_MANA = "mana";
    private int mana;
    public int redstoneSignal = 0;

    public TileEntityFunctionalFlower(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, IManaPool.class);
    }

    public boolean acceptsRedstone() {
        return false;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.drawManaFromPool();
        this.redstoneSignal = 0;
        if (this.acceptsRedstone()) {
            for (class_2350 dir : class_2350.values()) {
                int redstoneSide = this.method_10997().method_8499(this.method_11016().method_10093(dir), dir);
                this.redstoneSignal = Math.max(this.redstoneSignal, redstoneSide);
            }
        }
        if (this.method_10997().field_9236) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                BotaniaAPI.instance().sparkleFX(this.method_10997(), (double)this.method_11016().method_10263() + 0.3 + Math.random() * 0.5, (double)this.method_11016().method_10264() + 0.5 + Math.random() * 0.5, (double)this.method_11016().method_10260() + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
    }

    @Override
    public int getBindingRadius() {
        return 10;
    }

    @Override
    @Nullable
    public class_2338 findClosestTarget() {
        IManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        class_2586 closestPool = network.getClosestPool(this.method_11016(), this.method_10997(), this.getBindingRadius());
        return closestPool == null ? null : closestPool.method_11016();
    }

    public void drawManaFromPool() {
        IManaPool pool = (IManaPool)this.findBoundTile();
        if (pool != null) {
            int manaInPool = pool.getCurrentMana();
            int manaMissing = this.getMaxMana() - this.mana;
            int manaToRemove = Math.min(manaMissing, manaInPool);
            pool.receiveMana(-manaToRemove);
            this.addMana(manaToRemove);
        }
    }

    public int getMana() {
        return this.mana;
    }

    public void addMana(int mana) {
        this.mana = class_3532.method_15340((int)(this.mana + mana), (int)0, (int)this.getMaxMana());
        this.method_5431();
    }

    public abstract int getMaxMana();

    public abstract int getColor();

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.method_10550(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_MANA, this.mana);
    }

    public class_1799 getHudIcon() {
        return class_2378.field_11142.method_17966(POOL_ID).map(class_1799::new).orElse(class_1799.field_8037);
    }

    public static class FunctionalWandHud<T extends TileEntityFunctionalFlower>
    implements IWandHUD {
        protected final T flower;

        public FunctionalWandHud(T flower) {
            this.flower = flower;
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            String name = class_1074.method_4662((String)this.flower.method_11010().method_26204().method_9539(), (Object[])new Object[0]);
            int color = ((TileEntityFunctionalFlower)this.flower).getColor();
            BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, ((TileEntityFunctionalFlower)this.flower).getMana(), ((TileEntityFunctionalFlower)this.flower).getMaxMana(), name, ((TileEntityFunctionalFlower)this.flower).getHudIcon(), ((TileEntityBindableSpecialFlower)this.flower).isValidBinding());
        }
    }
}

