/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import vazkii.botania.api.block.IWandBindable;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.common.helper.MathHelper;

public abstract class TileEntityBindableSpecialFlower<T>
extends TileEntitySpecialFlower
implements IWandBindable {
    private final Class<T> bindClass;
    @Nullable
    protected class_2338 bindingPos = null;
    private static final String TAG_BINDING = "binding";

    public TileEntityBindableSpecialFlower(class_2591<?> type, class_2338 pos, class_2680 state, Class<T> bindClass) {
        super(type, pos, state);
        this.bindClass = bindClass;
    }

    public abstract int getBindingRadius();

    @Nullable
    public abstract class_2338 findClosestTarget();

    @Override
    protected void tickFlower() {
        super.tickFlower();
        if (!(this.ticksExisted != 1 || this.field_11863.field_9236 || this.bindingPos != null && this.isValidBinding())) {
            this.setBindingPos(this.findClosestTarget());
        }
    }

    @Nullable
    public class_2338 getBindingPos() {
        return this.bindingPos;
    }

    public void setBindingPos(@Nullable class_2338 bindingPos) {
        boolean changed = !Objects.equals(this.bindingPos, bindingPos);
        this.bindingPos = bindingPos;
        if (changed) {
            this.method_5431();
            this.sync();
        }
    }

    @Nullable
    public T findBindCandidateAt(class_2338 pos) {
        if (this.field_11863 == null || pos == null) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(pos);
        return (T)(be != null && this.bindClass.isAssignableFrom(be.getClass()) ? be : null);
    }

    @Nullable
    public T findBoundTile() {
        return this.findBindCandidateAt(this.bindingPos);
    }

    public boolean wouldBeValidBinding(@Nullable class_2338 pos) {
        if (this.field_11863 == null || pos == null || !this.field_11863.method_8477(pos) || MathHelper.distSqr((class_2382)this.method_11016(), (class_2382)pos) > (long)this.getBindingRadius() * (long)this.getBindingRadius()) {
            return false;
        }
        return this.findBindCandidateAt(pos) != null;
    }

    public boolean isValidBinding() {
        return this.wouldBeValidBinding(this.bindingPos);
    }

    @Override
    public class_2338 getBinding() {
        return this.isValidBinding() ? this.bindingPos : null;
    }

    @Override
    public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        return true;
    }

    @Override
    public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        if (this.wouldBeValidBinding(pos)) {
            this.setBindingPos(pos);
            return true;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        if (this.bindingPos != null) {
            cmp.method_10566(TAG_BINDING, (class_2520)class_2512.method_10692((class_2338)this.bindingPos));
        }
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.method_10545(TAG_BINDING)) {
            this.bindingPos = class_2512.method_10691((class_2487)cmp.method_10562(TAG_BINDING));
        } else {
            if (cmp.method_10545("collectorX")) {
                this.bindingPos = new class_2338(cmp.method_10550("collectorX"), cmp.method_10550("collectorY"), cmp.method_10550("collectorZ"));
            } else if (cmp.method_10545("poolX")) {
                this.bindingPos = new class_2338(cmp.method_10550("poolX"), cmp.method_10550("poolY"), cmp.method_10550("poolZ"));
            }
            if (this.bindingPos != null && this.bindingPos.method_10264() == -1) {
                this.bindingPos = null;
            }
        }
    }
}

