/*
 * Decompiled with CFR 0.152.
 */
package io.github.haykam821.smootherbedrock.mixin;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class SmootherBedrockMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_CLASS_PREFIX = "io.github.haykam821.smootherbedrock.mixin.";
    private static final String MIXIN_CLASS_1_16 = "io.github.haykam821.smootherbedrock.mixin.NoiseChunkGeneratorMixin116";
    private static final String MIXIN_CLASS_1_17 = "io.github.haykam821.smootherbedrock.mixin.NoiseChunkGeneratorMixin117";
    private static final String MIXIN_CLASS_1_18 = "io.github.haykam821.smootherbedrock.mixin.NoiseChunkGeneratorMixin118";
    private static final String MIXIN_CLASS_1_18_2 = "io.github.haykam821.smootherbedrock.mixin.NoiseChunkGeneratorMixin1182";
    private static final String MIXIN_CLASS_1_18_3 = "io.github.haykam821.smootherbedrock.mixin.VanillaSurfaceRulesMixin";
    private static final String MIXIN_CLASS_1_18_4 = "io.github.haykam821.smootherbedrock.mixin.VanillaSurfaceRulesMixin2";
    private static final String ACCESSOR_CLASS_1_18 = "io.github.haykam821.smootherbedrock.mixin.LayerTransitionBlockSourceAccessor";
    private static final String ACCESSOR_CLASS_1_18_2 = "io.github.haykam821.smootherbedrock.mixin.YOffsetAccessor";
    private static final String MIXIN_CLASS_ECOTONES = "io.github.haykam821.smootherbedrock.mixin.BaseEcotonesChunkGeneratorMixin";
    private static final Predicate<Version> IS_1_17 = SmootherBedrockMixinConfigPlugin.createVersionCompatibility(">=1.17-alpha.20.45.a");
    private static final Predicate<Version> IS_1_18 = SmootherBedrockMixinConfigPlugin.createVersionCompatibility(">=1.18-alpha.21.40.a");
    private static final Predicate<Version> IS_1_18_2 = SmootherBedrockMixinConfigPlugin.createVersionCompatibility(">=1.18-alpha.21.42.a");
    private static final Predicate<Version> IS_1_18_3 = SmootherBedrockMixinConfigPlugin.createVersionCompatibility(">=1.18-alpha.21.44.a");
    private static final Predicate<Version> IS_1_18_4 = SmootherBedrockMixinConfigPlugin.createVersionCompatibility(">=1.18-beta.5");
    private static final BooleanSupplier HAS_ECOTONES = SmootherBedrockMixinConfigPlugin.createModCompatibility("ecotones");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClass, String mixinClass) {
        if (mixinClass.equals(MIXIN_CLASS_1_16)) {
            return !IS_1_17.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(MIXIN_CLASS_1_17)) {
            return IS_1_17.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion()) && !IS_1_18.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(MIXIN_CLASS_1_18)) {
            return IS_1_18.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion()) && !IS_1_18_2.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(MIXIN_CLASS_1_18_2)) {
            return IS_1_18_2.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion()) && !IS_1_18_3.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(MIXIN_CLASS_1_18_3)) {
            return IS_1_18_3.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion()) && !IS_1_18_4.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(MIXIN_CLASS_1_18_4)) {
            return IS_1_18_4.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(ACCESSOR_CLASS_1_18)) {
            return IS_1_18.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion()) && !IS_1_18_3.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(ACCESSOR_CLASS_1_18_2)) {
            return IS_1_18_3.test(SmootherBedrockMixinConfigPlugin.getMinecraftVersion());
        }
        if (mixinClass.equals(MIXIN_CLASS_ECOTONES)) {
            return HAS_ECOTONES.getAsBoolean();
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static Version getMinecraftVersion() {
        Version version;
        Optional container = FabricLoader.getInstance().getModContainer("minecraft");
        if (container.isPresent() && (version = ((ModContainer)container.get()).getMetadata().getVersion()) instanceof SemanticVersion) {
            return version;
        }
        return null;
    }

    private static Predicate<Version> createVersionCompatibility(String versionRange) {
        try {
            return VersionPredicate.parse((String)versionRange);
        }
        catch (VersionParsingException exception) {
            return Predicates.alwaysFalse();
        }
    }

    private static BooleanSupplier createModCompatibility(String id) {
        return () -> FabricLoader.getInstance().isModLoaded(id);
    }
}

