/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag.extension;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.fabric.impl.tag.extension.FabricTagManagerHooks;
import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.fabricmc.fabric.mixin.tag.extension.DynamicRegistryManagerAccessor;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3494;
import net.minecraft.class_3503;
import net.minecraft.class_5120;
import net.minecraft.class_5321;
import net.minecraft.class_5323;
import net.minecraft.class_5413;
import net.minecraft.class_5414;
import net.minecraft.class_5455;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TagFactoryImpl<T>
implements TagFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagFactoryImpl.class);
    public static final Map<class_5321<? extends class_2378<?>>, class_5120<?>> TAG_LISTS = new HashMap();
    private final Supplier<class_5414<T>> tagGroupSupplier;

    public static <T> TagFactory<T> of(Supplier<class_5414<T>> tagGroupSupplier) {
        return new TagFactoryImpl<T>(tagGroupSupplier);
    }

    public static <T> TagFactory<T> of(class_5321<? extends class_2378<T>> registryKey, String dataType) {
        class_5120<?> tagList;
        if (TAG_LISTS.containsKey(registryKey)) {
            tagList = TAG_LISTS.get(registryKey);
            Preconditions.checkArgument((boolean)tagList.method_33149().equals(dataType), (String)"Tag list for registry %s is already existed with data type %s", (Object)registryKey.method_29177(), (Object)tagList.method_33149());
        } else {
            tagList = class_5413.method_30201(registryKey, (String)dataType);
            TAG_LISTS.put(registryKey, tagList);
        }
        return TagFactoryImpl.of(() -> tagList.method_26770());
    }

    public static void loadDynamicRegistryTags(class_5455 registryManager, class_3300 resourceManager) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int loadedTags = 0;
        for (class_5120<?> tagList : TAG_LISTS.values()) {
            if (!TagFactoryImpl.isDynamic(tagList)) continue;
            class_5321 registryKey = tagList.method_33148();
            class_2378 registry = registryManager.method_30530(registryKey);
            class_3503 tagGroupLoader = new class_3503(arg_0 -> ((class_2378)registry).method_17966(arg_0), tagList.method_33149());
            class_5414 tagGroup = tagGroupLoader.method_33176(resourceManager);
            ((FabricTagManagerHooks)class_5323.method_29223()).fabric_addTagGroup(registryKey, tagGroup);
            tagList.method_26771(class_5323.method_29223());
            loadedTags += tagGroup.method_30204().size();
        }
        if (loadedTags > 0) {
            LOGGER.info("Loaded {} dynamic registry tags in {}", (Object)loadedTags, (Object)stopwatch);
        }
    }

    public static boolean isDynamic(class_5120<?> tagList) {
        return DynamicRegistryManagerAccessor.getInfos().containsKey(tagList.method_33148());
    }

    private TagFactoryImpl(Supplier<class_5414<T>> tagGroupSupplier) {
        this.tagGroupSupplier = tagGroupSupplier;
    }

    @Override
    public class_3494.class_5123<T> create(class_2960 id) {
        return new TagDelegate<T>(id, this.tagGroupSupplier);
    }
}

