/*
 * Decompiled with CFR 0.152.
 */
package dqu.additionaladditions.config;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dqu.additionaladditions.AdditionalAdditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final int VERSION = 5;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PATH = FabricLoader.getInstance().getConfigDir().resolve("additional-additions-config.json").toString();
    private static final File DBFILE = new File(PATH);
    public static final HashMap<String, Integer> properties = new HashMap();
    public static boolean initialized = false;
    private static JsonObject db = new JsonObject();

    private static String format(String message) {
        return String.format("[%s] %s", "additionaladditions", message);
    }

    public static void init() {
        initialized = true;
        properties.put("FoodItems", 1);
        properties.put("WateringCan", 1);
        properties.put("RoseGold", 1);
        properties.put("Ropes", 1);
        properties.put("EnchantmentPrecision", 1);
        properties.put("EnchantmentSpeed", 3);
        properties.put("Wrench", 1);
        properties.put("CopperPatina", 1);
        properties.put("AmethystLamp", 1);
        properties.put("Crossbows", 1);
        properties.put("TridentShard", 2);
        properties.put("GlowStick", 2);
        properties.put("GildedNetherite", 3);
        properties.put("DepthMeter", 3);
        properties.put("Potions", 3);
        properties.put("MysteriousBundle", 3);
        properties.put("CompostableRottenFlesh", 3);
        properties.put("MusicDiscs", 4);
        properties.put("NoteBlockAmethystSounds", 5);
        properties.put("ShipwreckSpyglassLoot", 5);
        properties.put("PocketJukebox", 5);
        properties.put("ChickenNugget", 5);
        properties.put("PoweredRailsCopperRecipe", 5);
        properties.put("GoldRing", 5);
    }

    public static void load() {
        if (!DBFILE.exists()) {
            db.addProperty("version", (Number)5);
            for (String property : properties.keySet()) {
                db.addProperty(property, Boolean.valueOf(true));
            }
            Config.save();
        }
        try {
            BufferedReader bufferedReader = Files.newReader((File)DBFILE, (Charset)StandardCharsets.UTF_8);
            db = (JsonObject)GSON.fromJson((Reader)bufferedReader, JsonObject.class);
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(e.getMessage());
            AdditionalAdditions.LOGGER.error(Config.format("Unable to load configuration file!"));
        }
        if (db.get("version").getAsInt() != 5) {
            Config.convert(db.get("version").getAsInt());
        }
        Config.repair();
    }

    private static void save() {
        try {
            BufferedWriter bufferedWriter = Files.newWriter((File)DBFILE, (Charset)StandardCharsets.UTF_8);
            String json = GSON.toJson((JsonElement)db);
            bufferedWriter.write(json);
            bufferedWriter.close();
        }
        catch (Exception e) {
            AdditionalAdditions.LOGGER.error(e.getMessage());
            AdditionalAdditions.LOGGER.error(Config.format("Unable to save configuration file!"));
        }
    }

    public static boolean get(String key) {
        if (!initialized) {
            Config.init();
            Config.load();
        }
        return db.get(key).getAsBoolean();
    }

    public static void set(String key, boolean value) {
        if (!initialized) {
            Config.init();
            Config.load();
        }
        db.addProperty(key, Boolean.valueOf(value));
        Config.save();
    }

    private static void convert(int version) {
        for (String property : properties.keySet()) {
            if (properties.get(property) <= version && db.get(property) != null) continue;
            db.addProperty(property, Boolean.valueOf(true));
        }
        db.addProperty("version", (Number)5);
        AdditionalAdditions.LOGGER.info(Config.format("Converted outdated config."));
        Config.save();
    }

    private static void repair() {
        int repaired = 0;
        for (String property : properties.keySet()) {
            if (db.get(property) != null) continue;
            db.addProperty(property, Boolean.valueOf(true));
            ++repaired;
        }
        if (repaired > 0) {
            AdditionalAdditions.LOGGER.info(Config.format("Repaired " + repaired + " config properties"));
        }
        Config.save();
    }
}

