/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.kanos_config.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import virtuoel.kanos_config.api.ConfigBuilder;
import virtuoel.kanos_config.api.JsonConfigHandler;

public class JsonConfigBuilder
extends ConfigBuilder<JsonObject, JsonElement, JsonConfigHandler> {
    public JsonConfigBuilder(String namespace, String path) {
        super(namespace, path);
    }

    @Override
    public <T extends Number> Supplier<T> numberConfig(String member, Function<Number, T> mapper, T defaultValue) {
        return this.customConfig(c -> c.addProperty(member, defaultValue), config -> () -> Optional.ofNullable(((JsonObject)config.get()).get(member)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isNumber).map(JsonPrimitive::getAsNumber).map(mapper).orElse(defaultValue));
    }

    @Override
    public Supplier<Boolean> booleanConfig(String member, boolean defaultValue) {
        return this.customConfig(c -> c.addProperty(member, Boolean.valueOf(defaultValue)), config -> () -> Optional.ofNullable(((JsonObject)config.get()).get(member)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isBoolean).map(JsonPrimitive::getAsBoolean).orElse(defaultValue));
    }

    @Override
    public Supplier<String> stringConfig(String member, String defaultValue) {
        return this.customConfig(c -> c.addProperty(member, defaultValue), config -> () -> Optional.ofNullable(((JsonObject)config.get()).get(member)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).orElse(defaultValue));
    }

    @Override
    public Supplier<List<String>> stringListConfig(String config) {
        return this.listConfig(config, (Function)JsonElement::getAsString);
    }

    @Override
    public <T> Supplier<List<T>> listConfig(String member, Function<JsonElement, T> mapper) {
        return this.customConfig(c -> c.add(member, (JsonElement)new JsonArray()), config -> () -> Optional.ofNullable(((JsonObject)config.get()).get(member)).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).map(Iterable::spliterator).map(a -> StreamSupport.stream(a, false)).map(s -> s.map(mapper).collect(Collectors.toList())).orElseGet(ArrayList::new));
    }

    @Override
    protected JsonConfigHandler createConfig() {
        return new JsonConfigHandler(this.namespace, this.path, () -> this.populateDefaults(new JsonObject()));
    }
}

