/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.kanos_config.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import virtuoel.kanos_config.api.ConfigHandler;
import virtuoel.kanos_config.api.InvalidatableLazySupplier;

public abstract class ConfigBuilder<R, E, H extends ConfigHandler<R>> {
    protected final String namespace;
    protected final String path;
    private final Collection<Consumer<R>> defaultValues;
    public final H config;

    public ConfigBuilder(String namespace, String path) {
        this.namespace = namespace;
        this.path = path;
        this.defaultValues = new ArrayList<Consumer<R>>();
        this.config = this.createConfig();
    }

    public final Supplier<Double> doubleConfig(String config, double defaultValue) {
        return this.numberConfig(config, Number::doubleValue, defaultValue);
    }

    public final Supplier<Float> floatConfig(String config, float defaultValue) {
        return this.numberConfig(config, Number::floatValue, Float.valueOf(defaultValue));
    }

    public final Supplier<Long> longConfig(String config, long defaultValue) {
        return this.numberConfig(config, Number::longValue, defaultValue);
    }

    public final Supplier<Byte> byteConfig(String config, byte defaultValue) {
        return this.numberConfig(config, Number::byteValue, defaultValue);
    }

    public final Supplier<Short> shortConfig(String config, short defaultValue) {
        return this.numberConfig(config, Number::shortValue, defaultValue);
    }

    public final Supplier<Integer> intConfig(String config, int defaultValue) {
        return this.numberConfig(config, Number::intValue, defaultValue);
    }

    public abstract <T extends Number> Supplier<T> numberConfig(String var1, Function<Number, T> var2, T var3);

    public abstract Supplier<Boolean> booleanConfig(String var1, boolean var2);

    public abstract Supplier<String> stringConfig(String var1, String var2);

    public abstract Supplier<List<String>> stringListConfig(String var1);

    public abstract <T> Supplier<List<T>> listConfig(String var1, Function<E, T> var2);

    public final <T> Supplier<T> customConfig(Consumer<R> defaultValue, Function<H, Supplier<T>> entryFunction) {
        this.defaultValues.add(defaultValue);
        InvalidatableLazySupplier<T> entry = InvalidatableLazySupplier.of(entryFunction.apply(this.config));
        ((ConfigHandler)this.config).addInvalidationListener(entry::invalidate);
        return entry;
    }

    protected final R populateDefaults(R defaultConfig) {
        for (Consumer<R> value : this.defaultValues) {
            value.accept(defaultConfig);
        }
        return defaultConfig;
    }

    protected abstract H createConfig();
}

