/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.texture;

import com.google.gson.Gson;
import gg.moonflower.pollen.pinwheel.api.client.texture.TextureTableLoader;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelParser;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LocalTextureTableLoader
implements TextureTableLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private final Map<class_2960, GeometryModelTextureTable> textures = new HashMap<class_2960, GeometryModelTextureTable>();
    private final String folder;
    private String[] hashTables;

    public LocalTextureTableLoader() {
        this("textures/geometry");
    }

    public LocalTextureTableLoader(@Nullable String folder) {
        this.folder = folder == null || folder.isEmpty() ? "" : folder + "/";
        this.hashTables = new String[0];
    }

    @Override
    public void addTextures(BiConsumer<class_2960, GeometryModelTextureTable> textureConsumer) {
        this.textures.forEach(textureConsumer);
    }

    @Override
    public void addHashTables(Consumer<String> hashTableConsumer) {
        for (String hashTable : this.hashTables) {
            hashTableConsumer.accept(hashTable);
        }
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, GeometryModelTextureTable> textureLocations = new HashMap<class_2960, GeometryModelTextureTable>();
            for (class_2960 textureTableLocation : resourceManager.method_14488(this.folder, name -> name.endsWith(".json"))) {
                class_2960 textureTableName = new class_2960(textureTableLocation.method_12836(), textureTableLocation.method_12832().substring(this.folder.length(), textureTableLocation.method_12832().length() - 5));
                if (textureTableName.method_12832().equals("hash_tables")) continue;
                try {
                    class_3298 resource = resourceManager.method_14486(textureTableLocation);
                    try {
                        textureLocations.put(textureTableName, GeometryModelParser.parseTextures(new InputStreamReader(resource.method_14482())));
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load texture table '" + textureTableName + "'", (Throwable)e);
                }
            }
            LOGGER.info("Loaded " + textureLocations.size() + " model texture tables.");
            return textureLocations;
        }, backgroundExecutor).thenAcceptBothAsync(CompletableFuture.supplyAsync(() -> {
            HashSet<String> hashTables = new HashSet<String>();
            for (String domain : resourceManager.method_14487()) {
                class_2960 hashTableLocation = new class_2960(domain, this.folder + "hash_tables.json");
                if (!resourceManager.method_18234(hashTableLocation)) continue;
                try {
                    class_3298 resource = resourceManager.method_14486(hashTableLocation);
                    try {
                        hashTables.addAll(Arrays.asList((String[])GSON.fromJson((Reader)new InputStreamReader(resource.method_14482()), String[].class)));
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load texture hash table for " + domain, (Throwable)e);
                }
            }
            LOGGER.info("Loaded " + hashTables.size() + " hash tables.");
            return hashTables.toArray(new String[0]);
        }, backgroundExecutor), (textureLocations, hashTables) -> {
            this.textures.clear();
            this.textures.putAll((Map<class_2960, GeometryModelTextureTable>)textureLocations);
            this.hashTables = hashTables;
        }, gameExecutor)).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0));
    }
}

