/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.texture;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.pinwheel.api.client.FileCache;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GeometryTextureSpriteUploader
extends class_4080<class_1059.class_4007>
implements GeometryAtlasTexture,
AutoCloseable {
    public static final class_2960 ATLAS_LOCATION = new class_2960("pollen", "textures/atlas/geometry.png");
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_1059 textureAtlas = new class_1059(ATLAS_LOCATION);
    private final Set<GeometryModelTexture> textures = new HashSet<GeometryModelTexture>();
    private String[] hashTables = new String[0];

    public GeometryTextureSpriteUploader(class_1060 textureManager) {
        textureManager.method_4616(this.textureAtlas.method_24106(), (class_1044)this.textureAtlas);
    }

    private void beginStitch(long startTime, Stopwatch stopwatch) {
        stopwatch.start();
    }

    private void endStitch(Stopwatch stopwatch) {
        stopwatch.stop();
        LOGGER.debug("Took " + stopwatch + " to process " + this.textures.size() + " geometry textures");
    }

    @Override
    public class_2960 getAtlasLocation() {
        return ATLAS_LOCATION;
    }

    @Override
    public class_1058 getSprite(class_2960 location) {
        return this.textureAtlas.method_4608(location);
    }

    protected class_1059.class_4007 prepare(class_3300 resourceManager, class_3695 profiler) {
        try (OnlineRepository onlineRepository = new OnlineRepository(this.hashTables);){
            profiler.method_16065();
            profiler.method_15396("stitching");
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            this.beginStitch(System.currentTimeMillis(), stopwatch);
            class_1059.class_4007 sheetData = this.textureAtlas.method_18163((class_3300)new OnlineResourceManager(resourceManager, onlineRepository, this.textures.stream().filter(texture -> texture.getType() == GeometryModelTexture.Type.ONLINE).collect(Collectors.toSet())), this.textures.stream().filter(texture -> texture.getType() == GeometryModelTexture.Type.LOCATION || texture.getType() == GeometryModelTexture.Type.ONLINE).map(GeometryModelTexture::getLocation).distinct(), profiler, class_310.method_1551().field_1690.field_1856);
            this.endStitch(stopwatch);
            profiler.method_15407();
            profiler.method_16066();
            class_1059.class_4007 class_40072 = sheetData;
            return class_40072;
        }
    }

    protected void apply(class_1059.class_4007 sheetData, class_3300 resourceManager, class_3695 profiler) {
        profiler.method_16065();
        profiler.method_15396("upload");
        this.textureAtlas.method_18159(sheetData);
        profiler.method_15407();
        profiler.method_16066();
    }

    @Override
    public void close() {
        this.textureAtlas.method_4601();
    }

    public GeometryTextureSpriteUploader setTextures(Map<class_2960, GeometryModelTextureTable> textures, String[] hashTables) {
        this.textures.clear();
        this.textures.addAll(textures.values().stream().flatMap(table -> table.getTextures().stream().flatMap(Arrays::stream)).collect(Collectors.toSet()));
        this.hashTables = hashTables;
        return this;
    }

    private static class OnlineRepository
    implements AutoCloseable {
        private final ExecutorService executor = FileCache.createOnlineWorker();
        private final FileCache hashedCache;
        private final FileCache cache;
        private final Map<String, CompletableFuture<Path>> resources;

        private OnlineRepository(String[] hashTableUrls) {
            this.hashedCache = FileCache.hashed(this.executor, hashTableUrls);
            this.cache = FileCache.timed(this.executor, 1L, TimeUnit.DAYS);
            this.resources = new HashMap<String, CompletableFuture<Path>>();
        }

        public CompletableFuture<Path> requestResource(String url, boolean cache, boolean ignoreMissing) {
            return this.resources.computeIfAbsent(url, key -> cache ? this.hashedCache.requestResource(url, ignoreMissing) : this.cache.requestResource(url, ignoreMissing));
        }

        @Override
        public void close() {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Took more than 10 seconds to terminate online worker");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to terminate online worker", (Throwable)e);
            }
        }
    }

    private static class OnlineResourceManager
    implements class_3300 {
        private final class_3300 parent;
        private final OnlineRepository repository;
        private final Set<String> uncached;
        private final Map<String, Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>>> onlineLocations;

        private OnlineResourceManager(class_3300 parent, OnlineRepository repository, Set<GeometryModelTexture> onlineTextures) {
            this.parent = parent;
            this.repository = repository;
            this.uncached = onlineTextures.stream().filter(texture -> !texture.canCache()).map(GeometryModelTexture::getData).collect(Collectors.toSet());
            this.onlineLocations = onlineTextures.stream().map(GeometryModelTexture::getData).distinct().collect(Collectors.toMap(url -> url, this::updateCache));
        }

        @Nullable
        private static String parseUrl(class_2960 location) {
            String[] parts = location.method_12832().split("/");
            if (parts[parts.length - 1].startsWith("base32")) {
                return new String(new Base32().decode(parts[parts.length - 1].substring(6).toUpperCase(Locale.ROOT).replaceAll("_", "=")));
            }
            return null;
        }

        @Nullable
        private static InputStream read(CompletableFuture<Path> pathFuture) {
            try {
                Path path = pathFuture.join();
                return path == null ? null : new FileInputStream(path.toFile());
            }
            catch (Exception e) {
                LOGGER.error("Took too long to fetch texture data", (Throwable)e);
                return null;
            }
        }

        private Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>> updateCache(String url) {
            String extension = FilenameUtils.getExtension((String)url);
            String[] urlParts = url.split("." + extension);
            String metadataUrl = urlParts.length <= 1 ? url + ".mcmeta" : urlParts[0] + extension + ".mcmeta" + urlParts[1];
            CompletableFuture<Path> texturePath = this.repository.requestResource(url, !this.uncached.contains(url), false);
            CompletionStage metadataPath = this.repository.requestResource(metadataUrl, false, true).thenApplyAsync(path -> {
                JsonObject jsonObject;
                InputStream stream = OnlineResourceManager.read(CompletableFuture.completedFuture(path));
                if (stream == null) {
                    return null;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    jsonObject = class_3518.method_15255((Reader)bufferedreader);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                bufferedreader.close();
                return jsonObject;
            }, (Executor)class_156.method_27958());
            return Pair.of(texturePath, (Object)metadataPath);
        }

        public Set<String> method_14487() {
            return this.parent.method_14487();
        }

        public class_3298 method_14486(class_2960 resourceLocation) throws IOException {
            String url = OnlineResourceManager.parseUrl(new class_2960(resourceLocation.method_12836(), resourceLocation.method_12832().substring(9, resourceLocation.method_12832().length() - 4)));
            if (url != null) {
                if (!this.onlineLocations.containsKey(url)) {
                    throw new IOException("Failed to fetch texture data from '" + url + "'");
                }
                Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>> files = this.onlineLocations.get(url);
                InputStream textureStream = OnlineResourceManager.read((CompletableFuture)files.getLeft());
                if (textureStream == null) {
                    throw new IOException("Failed to fetch texture data from '" + url + "'");
                }
                return new OnlineResource(url, resourceLocation, textureStream, (JsonObject)((CompletableFuture)files.getRight()).join());
            }
            return this.parent.method_14486(resourceLocation);
        }

        public boolean method_18234(class_2960 resourceLocation) {
            return resourceLocation.method_12832().startsWith("base32") || this.parent.method_18234(resourceLocation);
        }

        public List<class_3298> method_14489(class_2960 resourceLocation) throws IOException {
            return this.parent.method_14489(resourceLocation);
        }

        public Collection<class_2960> method_14488(String path, Predicate<String> filter) {
            return this.parent.method_14488(path, filter);
        }

        public Stream<class_3262> method_29213() {
            return this.parent.method_29213();
        }

        private static class OnlineResource
        implements class_3298 {
            private final String url;
            private final class_2960 textureLocation;
            private final InputStream stream;
            private final JsonObject metadataJson;

            private OnlineResource(String url, class_2960 textureLocation, InputStream stream, @Nullable JsonObject metadataJson) {
                this.url = url;
                this.textureLocation = textureLocation;
                this.stream = stream;
                this.metadataJson = metadataJson;
            }

            public class_2960 method_14483() {
                return this.textureLocation;
            }

            public InputStream method_14482() {
                return this.stream;
            }

            public boolean method_14484() {
                return this.metadataJson != null;
            }

            @Nullable
            public <T> T method_14481(class_3270<T> serializer) {
                if (this.metadataJson == null) {
                    return null;
                }
                String s = serializer.method_14420();
                return (T)(this.metadataJson.has(s) ? serializer.method_14421(class_3518.method_15296((JsonObject)this.metadataJson, (String)s)) : null);
            }

            public String method_14480() {
                return "pollen_online";
            }

            public void close() throws IOException {
                this.stream.close();
            }

            public String toString() {
                return "OnlineResource{url='" + this.url + "', textureLocation=" + this.textureLocation + "}";
            }
        }
    }
}

