/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.geometry;

import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelParser;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class LocalGeometryModelLoader
implements BackgroundLoader<Map<class_2960, GeometryModel>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FOLDER = "models/geometry/";

    @Override
    public CompletableFuture<Map<class_2960, GeometryModel>> reload(class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, GeometryModel> modelLocations = new HashMap<class_2960, GeometryModel>();
            for (class_2960 modelLocation : resourceManager.method_14488(FOLDER, name -> name.endsWith(".json"))) {
                try {
                    class_3298 resource = resourceManager.method_14486(modelLocation);
                    try {
                        GeometryModelData[] models;
                        for (GeometryModelData model : models = GeometryModelParser.parseModel(IOUtils.toString((InputStream)resource.method_14482(), (Charset)StandardCharsets.UTF_8))) {
                            class_2960 id = new class_2960(modelLocation.method_12836(), model.getDescription().getIdentifier());
                            if (modelLocations.put(id, model.create()) == null) continue;
                            LOGGER.warn("Duplicate geometry model with id '" + id + "'");
                        }
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load geometry file '" + modelLocation.method_12836() + ":" + modelLocation.method_12832().substring(FOLDER.length(), modelLocation.method_12832().length() - 5) + "'", (Throwable)e);
                }
            }
            LOGGER.info("Loaded " + modelLocations.size() + " geometry models.");
            return modelLocations;
        }, backgroundExecutor);
    }
}

