/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.geometry;

import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModelPart;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BedrockGeometryModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BoneModelPart
extends class_630
implements AnimatedModelPart {
    private static final class_1162 TRANSFORM_VECTOR = new class_1162();
    private static final class_1160 NORMAL_VECTOR = new class_1160();
    private final BedrockGeometryModel parent;
    private final GeometryModelData.Bone bone;
    private final Set<BoneModelPart> children;
    private final Map<String, ObjectList<Quad>> quads;
    private final ObjectList<Polygon> polygons;
    private final class_1159 copyPosition;
    private final class_4581 copyNormal;
    private final AnimatedModelPart.AnimationPose animationPose;
    private boolean copyVanilla;

    public BoneModelPart(BedrockGeometryModel parent, GeometryModelData.Bone bone) {
        super(Collections.emptyList(), Collections.emptyMap());
        this.parent = parent;
        this.bone = bone;
        this.children = new HashSet<BoneModelPart>();
        this.quads = new Object2ObjectArrayMap();
        this.polygons = new ObjectArrayList();
        this.copyPosition = new class_1159();
        this.copyNormal = new class_4581();
        this.animationPose = new AnimatedModelPart.AnimationPose();
        this.resetTransform(false);
        Arrays.stream(bone.getCubes()).forEach(this::addCube);
        GeometryModelData.PolyMesh polyMesh = bone.getPolyMesh();
        if (polyMesh != null) {
            this.addPolyMesh(polyMesh);
        }
    }

    private static void addVertex(class_4588 builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, class_1159 matrix4f, Vertex vertex) {
        TRANSFORM_VECTOR.method_23851(vertex.x, vertex.y, vertex.z, 1.0f);
        TRANSFORM_VECTOR.method_22674(matrix4f);
        builder.method_23919(TRANSFORM_VECTOR.method_4953(), TRANSFORM_VECTOR.method_4956(), TRANSFORM_VECTOR.method_4957(), red, green, blue, alpha, vertex.u, vertex.v, packedOverlay, packedLight, NORMAL_VECTOR.method_4943(), NORMAL_VECTOR.method_4945(), NORMAL_VECTOR.method_4947());
    }

    private void addCube(GeometryModelData.Cube cube) {
        boolean mirror;
        boolean empty = true;
        for (class_2350 direction : class_2350.values()) {
            if (cube.getUV(direction) == null) continue;
            empty = false;
            break;
        }
        if (empty) {
            return;
        }
        class_1160 origin = cube.getOrigin();
        class_1160 size = cube.getSize();
        float x = origin.method_4943() / 16.0f;
        float y = origin.method_4945() / 16.0f;
        float z = origin.method_4947() / 16.0f;
        float sizeX = size.method_4943() / 16.0f;
        float sizeY = size.method_4945() / 16.0f;
        float sizeZ = size.method_4947() / 16.0f;
        float inflate = (cube.isOverrideInflate() ? cube.getInflate() : this.bone.getInflate()) / 16.0f;
        float x1 = x + sizeX;
        float y1 = y + sizeY;
        float z1 = z + sizeZ;
        if ((x -= inflate) == (x1 += inflate) && (y -= inflate) == (y1 += inflate) && (z -= inflate) == (z1 += inflate)) {
            return;
        }
        boolean bl = mirror = cube.isOverrideMirror() ? cube.isMirror() : this.bone.isMirror();
        if (mirror) {
            float f3 = x1;
            x1 = x;
            x = f3;
        }
        class_1160 rotation = cube.getRotation();
        class_1160 pivot = cube.getPivotX();
        float rotationX = rotation.method_4943();
        float rotationY = rotation.method_4945();
        float rotationZ = rotation.method_4947();
        float pivotX = pivot.method_4943() / 16.0f;
        float pivotY = -pivot.method_4945() / 16.0f;
        float pivotZ = pivot.method_4947() / 16.0f;
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904((double)pivotX, (double)pivotY, (double)pivotZ);
        matrixStack.method_22907(class_1160.field_20707.method_23214(rotationZ));
        matrixStack.method_22907(class_1160.field_20705.method_23214(rotationY));
        matrixStack.method_22907(class_1160.field_20703.method_23214(rotationX));
        matrixStack.method_22904((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_1159 matrix4f = entry.method_23761();
        class_4581 matrix3f = entry.method_23762();
        if (y != y1) {
            if (x != x1) {
                this.addFace(cube, matrix4f, matrix3f, x1, y1, z, x, y1, z, x, y, z, x1, y, z, class_2350.field_11043);
                this.addFace(cube, matrix4f, matrix3f, x, y1, z1, x1, y1, z1, x1, y, z1, x, y, z1, class_2350.field_11035);
            }
            if (z != z1) {
                this.addFace(cube, matrix4f, matrix3f, x, y1, z, x, y1, z1, x, y, z1, x, y, z, class_2350.field_11034);
                this.addFace(cube, matrix4f, matrix3f, x1, y1, z1, x1, y1, z, x1, y, z, x1, y, z1, class_2350.field_11039);
            }
        }
        if (x != x1 && z != z1) {
            this.addFace(cube, matrix4f, matrix3f, x, y, z1, x1, y, z1, x1, y, z, x, y, z, class_2350.field_11033);
            this.addFace(cube, matrix4f, matrix3f, x1, y1, z1, x, y1, z1, x, y1, z, x1, y1, z, class_2350.field_11036);
        }
    }

    private void addPolyMesh(GeometryModelData.PolyMesh polyMesh) {
        class_1159 matrix4f = new class_1159();
        matrix4f.method_22668();
        for (GeometryModelData.Poly poly : polyMesh.getPolys()) {
            Vertex[] vertices = new Vertex[polyMesh.getPolyType().getVertices()];
            class_1160[] normals = new class_1160[polyMesh.getPolyType().getVertices()];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = this.getVertex(polyMesh, poly, matrix4f, i);
                normals[i] = polyMesh.getNormals()[poly.getNormals()[i]].method_23850();
                normals[i].method_23849(1.0f, -1.0f, 1.0f);
            }
            this.polygons.add((Object)new Polygon(vertices, normals));
        }
    }

    private Vertex getVertex(GeometryModelData.PolyMesh polyMesh, GeometryModelData.Poly poly, class_1159 matrix4f, int index) {
        class_1160 position = polyMesh.getPositions()[poly.getPositions()[index]];
        class_241 uv = polyMesh.getUvs()[poly.getUVs()[index]];
        return new Vertex(matrix4f, position.method_4943(), -position.method_4945(), position.method_4947(), polyMesh.isNormalizedUvs() ? uv.field_1343 : uv.field_1343 / this.parent.getTextureWidth(), 1.0f - (polyMesh.isNormalizedUvs() ? uv.field_1342 : uv.field_1342 / this.parent.getTextureHeight()));
    }

    private void addFace(GeometryModelData.Cube cube, class_1159 matrix4f, class_4581 matrix3f, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, class_2350 face) {
        GeometryModelData.CubeUV uv = cube.getUV(face);
        if (uv != null) {
            this.quads.computeIfAbsent(uv.getMaterialInstance(), __ -> new ObjectArrayList()).add((Object)new Quad(new Vertex[]{new Vertex(matrix4f, x0, -y0, z0, (uv.getU() + uv.getUSize()) / this.parent.getTextureWidth(), uv.getV() / this.parent.getTextureHeight()), new Vertex(matrix4f, x1, -y1, z1, uv.getU() / this.parent.getTextureWidth(), uv.getV() / this.parent.getTextureHeight()), new Vertex(matrix4f, x2, -y2, z2, uv.getU() / this.parent.getTextureWidth(), (uv.getV() + uv.getVSize()) / this.parent.getTextureHeight()), new Vertex(matrix4f, x3, -y3, z3, (uv.getU() + uv.getUSize()) / this.parent.getTextureWidth(), (uv.getV() + uv.getVSize()) / this.parent.getTextureHeight())}, matrix3f, uv.getMaterialInstance(), cube.isOverrideMirror() ? cube.isMirror() : this.bone.isMirror(), face.method_10153()));
        }
    }

    void addChild(BoneModelPart part) {
        this.children.add(part);
    }

    public void resetTransform(boolean resetChildren) {
        class_1160 rotation = this.bone.getRotation();
        class_1160 pivot = this.bone.getPivot();
        this.field_3654 = (float)Math.PI / 180 * rotation.method_4943();
        this.field_3675 = (float)Math.PI / 180 * rotation.method_4945();
        this.field_3674 = (float)Math.PI / 180 * rotation.method_4947();
        this.field_3657 = pivot.method_4943();
        this.field_3656 = -pivot.method_4945();
        this.field_3655 = pivot.method_4947();
        this.copyPosition.method_22668();
        this.copyNormal.method_22856();
        this.animationPose.reset();
        if (resetChildren) {
            this.children.forEach(boneModelPart -> boneModelPart.resetTransform(true));
        }
        this.copyVanilla = false;
    }

    public void method_22699(class_4587 matrixStack, class_4588 builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.method_22699(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
        if (!(!this.field_3665 || !(alpha > 0.0f) || this.quads.isEmpty() && this.polygons.isEmpty() && this.children.isEmpty())) {
            matrixStack.method_22903();
            this.method_22703(matrixStack);
            if (this.copyVanilla) {
                matrixStack.method_22904((double)(-this.field_3657 / 16.0f), (double)(-this.field_3656 / 16.0f), (double)(-this.field_3655 / 16.0f));
            }
            class_1159 matrix4f = matrixStack.method_23760().method_23761();
            class_4581 matrix3f = matrixStack.method_23760().method_23762();
            Collection quads = (Collection)this.quads.get(this.parent.getActiveMaterial());
            if (quads != null) {
                for (Quad quad : quads) {
                    NORMAL_VECTOR.method_4949(-quad.normal.method_4943(), quad.normal.method_4945(), -quad.normal.method_4947());
                    NORMAL_VECTOR.method_23215(matrix3f);
                    for (Vertex vertex : quad.vertices) {
                        BoneModelPart.addVertex(builder, packedLight, packedOverlay, red, green, blue, alpha, matrix4f, vertex);
                    }
                }
            }
            if ("poly_mesh.texture".equals(this.parent.getActiveMaterial())) {
                for (Polygon polygon : this.polygons) {
                    for (int i = 0; i < 4; ++i) {
                        int index = class_3532.method_15340((int)i, (int)0, (int)(polygon.vertices.length - 1));
                        Vertex vertex = polygon.vertices[index];
                        class_1160 normal = polygon.normals[index];
                        NORMAL_VECTOR.method_4949(normal.method_4943(), normal.method_4945(), normal.method_4947());
                        NORMAL_VECTOR.method_23215(matrix3f);
                        BoneModelPart.addVertex(builder, packedLight, packedOverlay, red, green, blue, alpha, matrix4f, vertex);
                    }
                }
            }
            for (class_630 part : this.children) {
                part.method_22699(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
            }
            matrixStack.method_22909();
        }
    }

    public void method_17138(class_630 part) {
        this.copyPosition.method_22668();
        this.copyNormal.method_22856();
        class_4587 matrixStack = new class_4587();
        part.method_22703(matrixStack);
        this.copyPosition.method_22672(matrixStack.method_23760().method_23761());
        this.copyNormal.method_22855(matrixStack.method_23760().method_23762());
        this.copyVanilla = !BoneModelPart.class.isAssignableFrom(part.getClass());
    }

    public void method_22703(class_4587 matrixStack) {
        matrixStack.method_23760().method_23761().method_22672(this.copyPosition);
        matrixStack.method_23760().method_23762().method_22855(this.copyNormal);
        matrixStack.method_22904((double)((this.animationPose.getPosition().method_4943() + this.field_3657) / 16.0f), (double)((-this.animationPose.getPosition().method_4945() + this.field_3656) / 16.0f), (double)((this.animationPose.getPosition().method_4947() + this.field_3655) / 16.0f));
        if (this.animationPose.getScale().hashCode() != 1333788672) {
            matrixStack.method_22905(this.animationPose.getScale().method_4943(), this.animationPose.getScale().method_4945(), this.animationPose.getScale().method_4947());
        }
        if (this.field_3674 + this.animationPose.getRotation().method_4947() != 0.0f) {
            matrixStack.method_22907(class_1160.field_20707.method_23626(this.field_3674 + (float)((double)(this.animationPose.getRotation().method_4947() / 180.0f) * Math.PI)));
        }
        if (this.field_3675 + this.animationPose.getRotation().method_4945() != 0.0f) {
            matrixStack.method_22907(class_1160.field_20705.method_23626(this.field_3675 + (float)((double)(this.animationPose.getRotation().method_4945() / 180.0f) * Math.PI)));
        }
        if (this.field_3654 + this.animationPose.getRotation().method_4943() != 0.0f) {
            matrixStack.method_22907(class_1160.field_20703.method_23626(this.field_3654 + (float)((double)(this.animationPose.getRotation().method_4943() / 180.0f) * Math.PI)));
        }
        matrixStack.method_22904((double)(-this.field_3657 / 16.0f), (double)(-this.field_3656 / 16.0f), (double)(-this.field_3655 / 16.0f));
    }

    public GeometryModelData.Bone getBone() {
        return this.bone;
    }

    @Override
    public AnimatedModelPart.AnimationPose getAnimationPose() {
        return this.animationPose;
    }

    @Override
    public GeometryModelData.Locator[] getLocators() {
        return this.bone.getLocators();
    }

    private static class Vertex {
        private final float x;
        private final float y;
        private final float z;
        private final float u;
        private final float v;

        private Vertex(class_1159 matrix4f, float x, float y, float z, float u, float v) {
            TRANSFORM_VECTOR.method_23851(x, y, z, 1.0f);
            TRANSFORM_VECTOR.method_22674(matrix4f);
            this.x = TRANSFORM_VECTOR.method_4953();
            this.y = TRANSFORM_VECTOR.method_4956();
            this.z = TRANSFORM_VECTOR.method_4957();
            this.u = u;
            this.v = v;
        }
    }

    private static class Polygon {
        private final Vertex[] vertices;
        private final class_1160[] normals;

        public Polygon(Vertex[] vertices, class_1160[] normals) {
            this.vertices = vertices;
            this.normals = normals;
        }
    }

    private static class Quad {
        private final Vertex[] vertices;
        private final class_1160 normal;
        private final String material;

        public Quad(Vertex[] vertices, class_4581 normal, String material, boolean mirror, class_2350 direction) {
            this.vertices = vertices;
            this.material = material;
            if (mirror) {
                int i = vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex vertex = vertices[j];
                    vertices[j] = vertices[i - 1 - j];
                    vertices[i - 1 - j] = vertex;
                }
            }
            this.normal = direction.method_23955();
            if (mirror) {
                this.normal.method_23849(-1.0f, 1.0f, 1.0f);
            }
            this.normal.method_23215(normal);
        }
    }
}

