/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.animation;

import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationParser;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocalAnimationLoader
implements BackgroundLoader<Map<class_2960, AnimationData>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String folder;

    public LocalAnimationLoader() {
        this("animations");
    }

    public LocalAnimationLoader(String folder) {
        this.folder = folder.isEmpty() ? "" : folder + "/";
    }

    @Override
    public CompletableFuture<Map<class_2960, AnimationData>> reload(class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, AnimationData> animationData = new HashMap<class_2960, AnimationData>();
            for (class_2960 animationLocation : resourceManager.method_14488(this.folder, name -> name.endsWith(".json"))) {
                try {
                    class_3298 resource = resourceManager.method_14486(animationLocation);
                    try {
                        AnimationData[] animations;
                        for (AnimationData animation : animations = AnimationParser.parse(new InputStreamReader(resource.method_14482()))) {
                            class_2960 id = new class_2960(animationLocation.method_12836(), animation.getName());
                            if (animationData.put(id, animation) == null) continue;
                            LOGGER.warn("Duplicate animation: " + id);
                        }
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load animation: " + animationLocation.method_12836() + ":" + animationLocation.method_12832().substring(this.folder.length(), animationLocation.method_12832().length() - 5), (Throwable)e);
                }
            }
            return animationData;
        }, backgroundExecutor);
    }
}

