/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client;

import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.pinwheel.api.client.blockdata.BlockData;
import gg.moonflower.pollen.pinwheel.api.client.blockdata.BlockDataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BlockDataStorage {
    private static final Map<class_1922, BlockDataStorage> DATA = new WeakHashMap<class_1922, BlockDataStorage>(3);
    private final class_1922 level;
    private final Map<class_2338, Map<BlockDataKey<?>, BlockData<?>>> data;

    private BlockDataStorage(class_1922 level) {
        this.level = level;
        this.data = new HashMap();
    }

    public <T> BlockData<T> get(BlockDataKey<T> key, class_2338 pos) {
        class_2680 state = this.level.method_8320(pos);
        Map map = this.data.computeIfAbsent(pos.method_10062(), __ -> new HashMap());
        if (map.containsKey(key) && !key.getFilter().test(state)) {
            map.remove(key);
        }
        return map.computeIfAbsent(key, BlockDataImpl::new);
    }

    public void invalidateChunk(class_1923 chunkPos) {
        this.data.keySet().removeIf(pos -> pos.method_10263() >= chunkPos.method_8326() && pos.method_10263() < chunkPos.method_8327() && pos.method_10260() >= chunkPos.method_8328() && pos.method_10260() < chunkPos.method_8329());
    }

    public static BlockDataStorage get(class_1922 level) {
        return DATA.computeIfAbsent(level, BlockDataStorage::new);
    }

    public void update(class_2680 state, class_2338 pos) {
        if (!this.data.containsKey(pos)) {
            return;
        }
        Map<BlockDataKey<?>, BlockData<?>> map = this.data.get(pos);
        map.keySet().removeIf(key -> !key.getFilter().test(state));
    }

    static {
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> DATA.clear());
    }

    private static class BlockDataImpl<T>
    implements BlockData<T> {
        private final Supplier<T> defaultValue;
        private T value;

        private BlockDataImpl(BlockDataKey<T> key) {
            this.defaultValue = key.getDefault();
            this.value = key.getDefault().get();
        }

        @Override
        public void set(@Nullable T value) {
            this.value = value != null ? value : this.defaultValue.get();
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

