/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.texture;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GeometryModelTextureTable {
    public static final Codec<GeometryModelTextureTable> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)GeometryModelTexture.CODEC.listOf().xmap(list -> list.toArray(new GeometryModelTexture[0]), Arrays::asList)).xmap(GeometryModelTextureTable::new, table -> table.textures);
    public static GeometryModelTextureTable EMPTY = new GeometryModelTextureTable(new HashMap<String, GeometryModelTexture[]>());
    private final Map<String, GeometryModelTexture[]> textures;

    public GeometryModelTextureTable(Map<String, GeometryModelTexture[]> textures) {
        this.textures = new HashMap<String, GeometryModelTexture[]>(textures);
        this.textures.values().removeIf(layers -> ((GeometryModelTexture[])layers).length == 0);
    }

    public GeometryModelTexture[] getLayerTextures(@Nullable String key) {
        return this.textures.getOrDefault(key, new GeometryModelTexture[]{GeometryModelTexture.MISSING});
    }

    public Collection<GeometryModelTexture[]> getTextures() {
        return this.textures.values();
    }

    public Map<String, GeometryModelTexture[]> getTextureDefinitions() {
        return this.textures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryModelTextureTable that = (GeometryModelTextureTable)o;
        return this.textures.equals(that.textures);
    }

    public int hashCode() {
        return Objects.hash(this.textures);
    }

    public String toString() {
        return "GeometryModelTextureTable{textures=" + this.textures + "}";
    }

    public static class Serializer
    implements JsonSerializer<GeometryModelTextureTable>,
    JsonDeserializer<GeometryModelTextureTable> {
        private static final Logger LOGGER = LogManager.getLogger();

        public JsonElement serialize(GeometryModelTextureTable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject texturesObject = new JsonObject();
            for (Map.Entry<String, GeometryModelTexture[]> entry : src.textures.entrySet()) {
                GeometryModelTexture[] layers = entry.getValue();
                if (layers.length == 0) continue;
                if (layers.length == 1) {
                    texturesObject.add(entry.getKey(), (JsonElement)GeometryModelTexture.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)layers[0]).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                    continue;
                }
                JsonArray layersJson = new JsonArray();
                for (GeometryModelTexture texture : layers) {
                    layersJson.add((JsonElement)GeometryModelTexture.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)texture).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                }
                texturesObject.add(entry.getKey(), (JsonElement)layersJson);
            }
            return texturesObject;
        }

        public GeometryModelTextureTable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject texturesObject = json.getAsJsonObject();
            HashMap<String, GeometryModelTexture[]> textures = new HashMap<String, GeometryModelTexture[]>();
            ArrayList<GeometryModelTexture> textureSet = new ArrayList<GeometryModelTexture>();
            for (Map.Entry entry : texturesObject.entrySet()) {
                try {
                    if (((JsonElement)entry.getValue()).isJsonArray()) {
                        JsonArray layersJson = ((JsonElement)entry.getValue()).getAsJsonArray();
                        for (int i = 0; i < layersJson.size(); ++i) {
                            textureSet.add((GeometryModelTexture)GeometryModelTexture.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)layersJson.get(i)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                        }
                        if (textureSet.isEmpty()) continue;
                        textures.put((String)entry.getKey(), textureSet.toArray(new GeometryModelTexture[0]));
                        textureSet.clear();
                        continue;
                    }
                    GeometryModelTexture[] geometryModelTextureArray = new GeometryModelTexture[1];
                    geometryModelTextureArray[0] = (GeometryModelTexture)GeometryModelTexture.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                    textures.put((String)entry.getKey(), geometryModelTextureArray);
                }
                catch (Exception e) {
                    throw new JsonParseException("Failed to load texture '" + (String)entry.getKey() + "'", (Throwable)e);
                }
            }
            return new GeometryModelTextureTable(textures);
        }
    }
}

