/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.texture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.core.client.geometry.GeometryRenderTypes;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class GeometryModelTexture {
    public static final GeometryModelTexture MISSING = new GeometryModelTexture(Type.UNKNOWN, TextureLayer.SOLID, "missingno", false, -1, false);
    public static final Codec<GeometryModelTexture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(Type::byName, type -> type.name().toLowerCase(Locale.ROOT)).fieldOf("type").forGetter(GeometryModelTexture::getType), (App)Codec.STRING.xmap(TextureLayer::byName, type -> type.name().toLowerCase(Locale.ROOT)).optionalFieldOf("layer", (Object)TextureLayer.SOLID).forGetter(GeometryModelTexture::getLayer), (App)Codec.STRING.fieldOf("texture").forGetter(GeometryModelTexture::getData), (App)Codec.BOOL.optionalFieldOf("cache", (Object)true).forGetter(GeometryModelTexture::canCache), (App)Codec.STRING.optionalFieldOf("color", (Object)"0xFFFFFF").xmap(NumberUtils::createInteger, color -> "0x" + Integer.toHexString(color & 0xFFFFFF).toUpperCase(Locale.ROOT)).forGetter(GeometryModelTexture::getColor), (App)Codec.BOOL.optionalFieldOf("glowing", (Object)false).forGetter(GeometryModelTexture::isGlowing)).apply((Applicative)instance, GeometryModelTexture::new));
    private static final Pattern ONLINE_PATTERN = Pattern.compile("=");
    private final Type type;
    private final TextureLayer layer;
    private final String data;
    private final boolean cache;
    private final int color;
    private final boolean glowing;
    private final class_2960 location;

    @ApiStatus.Internal
    public GeometryModelTexture(Type type, TextureLayer layer, String data, boolean cache, int color, boolean glowing) {
        this.type = type;
        this.layer = layer;
        this.data = data;
        this.cache = cache;
        this.color = color;
        this.glowing = glowing;
        this.location = type.createLocation(data);
        Validate.notNull((Object)this.location, (String)("Invalid texture data: " + data), (Object[])new Object[0]);
    }

    public static Builder texture() {
        return new Builder();
    }

    public static Builder texture(GeometryModelTexture texture) {
        return new Builder(texture);
    }

    public Type getType() {
        return this.type;
    }

    public TextureLayer getLayer() {
        return this.layer;
    }

    public String getData() {
        return this.data;
    }

    public boolean canCache() {
        return this.cache;
    }

    public int getColor() {
        return this.color;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryModelTexture that = (GeometryModelTexture)o;
        return this.cache == that.cache && this.color == that.color && this.glowing == that.glowing && this.type == that.type && this.layer == that.layer && this.data.equals(that.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.layer, this.data, this.cache, this.color, this.glowing});
    }

    public String toString() {
        return "GeometryModelTexture{type=" + this.type + ", layer=" + this.layer + ", data='" + this.data + "', cache=" + this.cache + ", color=" + this.color + ", glowing=" + this.glowing + "}";
    }

    public static enum Type {
        UNKNOWN(location -> new class_2960("missingno")),
        LOCATION(class_2960::method_12829),
        ONLINE(location -> new class_2960("pollen", "base32" + ONLINE_PATTERN.matcher(new Base32().encodeAsString(location.getBytes()).toLowerCase(Locale.ROOT)).replaceAll("_")));

        private final Function<String, class_2960> locationGenerator;

        private Type(Function<String, class_2960> locationGenerator) {
            this.locationGenerator = locationGenerator;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return UNKNOWN;
        }

        @Nullable
        public class_2960 createLocation(String data) {
            return this.locationGenerator.apply(data);
        }
    }

    public static enum TextureLayer {
        SOLID(() -> GeometryRenderTypes::getGeometrySolid),
        CUTOUT(() -> GeometryRenderTypes::getGeometryCutout),
        CUTOUT_CULL(() -> GeometryRenderTypes::getGeometryCutoutCull),
        TRANSLUCENT(() -> GeometryRenderTypes::getGeometryTranslucent),
        TRANSLUCENT_CULL(() -> GeometryRenderTypes::getGeometryTranslucentCull);

        private final Supplier<RenderTypeFunction> renderTypeGetter;

        private TextureLayer(Supplier<RenderTypeFunction> renderTypeGetter) {
            this.renderTypeGetter = renderTypeGetter;
        }

        public static TextureLayer byName(String name) {
            for (TextureLayer layer : TextureLayer.values()) {
                if (!layer.name().equalsIgnoreCase(name)) continue;
                return layer;
            }
            return CUTOUT;
        }

        @Environment(value=EnvType.CLIENT)
        public class_1921 getRenderType(GeometryModelTexture texture, GeometryAtlasTexture atlas, @Nullable Consumer<class_1921.class_4688.class_4689> renderTypeConsumer) {
            return this.renderTypeGetter.get().apply(texture, atlas, renderTypeConsumer);
        }
    }

    public static class Builder {
        private Type type;
        private TextureLayer layer;
        private String data;
        private boolean cache;
        private int color;
        private boolean glowing;

        private Builder() {
            this.type = Type.UNKNOWN;
            this.layer = TextureLayer.SOLID;
            this.data = "";
            this.cache = false;
            this.color = -1;
            this.glowing = false;
        }

        private Builder(GeometryModelTexture texture) {
            this.type = texture.getType();
            this.layer = texture.getLayer();
            this.data = texture.getData();
            this.cache = texture.canCache();
            this.color = texture.getColor();
            this.glowing = texture.isGlowing();
        }

        public Builder setTextureLocation(class_2960 texture) {
            this.type = Type.LOCATION;
            this.data = texture.toString();
            this.cache = false;
            return this;
        }

        public Builder setTextureOnline(String url, boolean cache) {
            this.type = Type.ONLINE;
            this.data = url;
            this.cache = cache;
            return this;
        }

        public Builder setTextureLayer(TextureLayer layer) {
            this.layer = layer;
            return this;
        }

        public Builder setColor(int color) {
            this.color = color;
            return this;
        }

        public Builder setGlowing(boolean glowing) {
            this.glowing = glowing;
            return this;
        }

        public GeometryModelTexture build() {
            return new GeometryModelTexture(this.type, this.layer, this.data, this.cache, this.color, this.glowing);
        }
    }

    @FunctionalInterface
    private static interface RenderTypeFunction {
        @Environment(value=EnvType.CLIENT)
        public class_1921 apply(GeometryModelTexture var1, GeometryAtlasTexture var2, @Nullable Consumer<class_1921.class_4688.class_4689> var3);
    }
}

