/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.geometry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import gg.moonflower.pollen.pinwheel.core.common.geometry.Geometry110Parser;
import gg.moonflower.pollen.pinwheel.core.common.geometry.Geometry1120Parser;
import gg.moonflower.pollen.pinwheel.core.common.geometry.Geometry180Parser;
import java.io.Reader;
import net.minecraft.class_3518;

public final class GeometryModelParser {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(GeometryModelTextureTable.class, (Object)new GeometryModelTextureTable.Serializer()).create();

    private GeometryModelParser() {
    }

    public static GeometryModelData[] parseModel(Reader reader) throws JsonParseException {
        return GeometryModelParser.parseModel(new JsonParser().parse(reader));
    }

    public static GeometryModelData[] parseModel(JsonReader reader) throws JsonParseException {
        return GeometryModelParser.parseModel(new JsonParser().parse(reader));
    }

    public static GeometryModelData[] parseModel(String json) throws JsonParseException {
        return GeometryModelParser.parseModel(new JsonParser().parse(json));
    }

    public static GeometryModelData[] parseModel(JsonElement json) throws JsonParseException {
        String formatVersion = class_3518.method_15265((JsonObject)json.getAsJsonObject(), (String)"format_version");
        if (formatVersion.equals("1.12.0")) {
            return Geometry1120Parser.parseModel(json);
        }
        if (formatVersion.equals("1.8.0")) {
            return Geometry180Parser.parseModel(json);
        }
        if (formatVersion.equals("1.1.0")) {
            return Geometry110Parser.parseModel(json);
        }
        throw new JsonSyntaxException("Unsupported geometry version: " + formatVersion);
    }

    public static GeometryModelTextureTable parseTextures(Reader reader) throws JsonParseException {
        return GeometryModelParser.parseTextures(new JsonParser().parse(reader));
    }

    public static GeometryModelTextureTable parseTextures(JsonReader reader) throws JsonParseException {
        return GeometryModelParser.parseTextures(new JsonParser().parse(reader));
    }

    public static GeometryModelTextureTable parseTextures(String json) throws JsonParseException {
        return GeometryModelParser.parseTextures(new JsonParser().parse(json));
    }

    public static GeometryModelTextureTable parseTextures(JsonElement json) throws JsonParseException {
        return (GeometryModelTextureTable)GSON.fromJson(json, GeometryModelTextureTable.class);
    }
}

