/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_3518;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class GeometryModelData {
    public static final GeometryModelData EMPTY = new GeometryModelData(new Description("empty", 0.0f, 0.0f, new class_1160(), 256, 256, false), new Bone[0]);
    private final Description description;
    private final Bone[] bones;

    public GeometryModelData(Description description, Bone[] bones) {
        this.description = description;
        this.bones = bones;
    }

    public GeometryModel create() {
        return GeometryModel.create(this);
    }

    public Description getDescription() {
        return this.description;
    }

    public Bone[] getBones() {
        return this.bones;
    }

    public String toString() {
        return "BedrockModel{description=" + this.description + ", bones=" + Arrays.toString(this.bones) + "}";
    }

    public static class Description {
        private final String identifier;
        private final float visibleBoundsWidth;
        private final float visibleBoundsHeight;
        private final class_1160 visibleBoundsOffset;
        private final int textureWidth;
        private final int textureHeight;
        private final boolean preserveModelPose2588;

        public Description(String identifier, float visibleBoundsWidth, float visibleBoundsHeight, class_1160 visibleBoundsOffset, int textureWidth, int textureHeight, boolean preserveModelPose2588) {
            this.identifier = identifier;
            this.visibleBoundsWidth = visibleBoundsWidth;
            this.visibleBoundsHeight = visibleBoundsHeight;
            this.visibleBoundsOffset = visibleBoundsOffset;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.preserveModelPose2588 = preserveModelPose2588;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public float getVisibleBoundsWidth() {
            return this.visibleBoundsWidth;
        }

        public float getVisibleBoundsHeight() {
            return this.visibleBoundsHeight;
        }

        public class_1160 getVisibleBoundsOffset() {
            return this.visibleBoundsOffset;
        }

        public int getTextureWidth() {
            return this.textureWidth;
        }

        public int getTextureHeight() {
            return this.textureHeight;
        }

        public boolean isPreserveModelPose2588() {
            return this.preserveModelPose2588;
        }

        public String toString() {
            return "Description{identifier='" + this.identifier + "', visibleBoundsWidth=" + this.visibleBoundsWidth + ", visibleBoundsHeight=" + this.visibleBoundsHeight + ", visibleBoundsOffset=" + this.visibleBoundsOffset + ", textureWidth=" + this.textureWidth + ", textureHeight=" + this.textureHeight + ", preserveModelPose2588=" + this.preserveModelPose2588 + "}";
        }
    }

    public static class Bone {
        private final String name;
        private final boolean reset2588;
        private final boolean neverRender2588;
        private final String parent;
        private final class_1160 pivot;
        private final class_1160 rotation;
        private final class_1160 bindPoseRotation2588;
        private final boolean mirror;
        private final float inflate;
        private final boolean debug;
        private final Cube[] cubes;
        private final Locator[] locators;
        private final PolyMesh polyMesh;

        public Bone(String name, boolean reset2588, boolean neverRender2588, @Nullable String parent, class_1160 pivot, class_1160 rotation, class_1160 bindPoseRotation2588, boolean mirror, float inflate, boolean debug, Cube[] cubes, Locator[] locators, @Nullable PolyMesh polyMesh) {
            this.name = name;
            this.reset2588 = reset2588;
            this.neverRender2588 = neverRender2588;
            this.parent = parent;
            this.pivot = pivot;
            this.rotation = rotation;
            this.bindPoseRotation2588 = bindPoseRotation2588;
            this.mirror = mirror;
            this.inflate = inflate;
            this.debug = debug;
            this.cubes = cubes;
            this.locators = locators;
            this.polyMesh = polyMesh;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReset2588() {
            return this.reset2588;
        }

        public boolean isNeverRender2588() {
            return this.neverRender2588;
        }

        @Nullable
        public String getParent() {
            return this.parent;
        }

        public class_1160 getPivot() {
            return this.pivot;
        }

        public class_1160 getRotation() {
            return this.rotation;
        }

        public class_1160 getBindPoseRotation2588() {
            return this.bindPoseRotation2588;
        }

        public boolean isMirror() {
            return this.mirror;
        }

        public float getInflate() {
            return this.inflate;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public Cube[] getCubes() {
            return this.cubes;
        }

        public Locator[] getLocators() {
            return this.locators;
        }

        @Nullable
        public PolyMesh getPolyMesh() {
            return this.polyMesh;
        }

        public String toString() {
            return "Bone{name='" + this.name + "', reset2588=" + this.reset2588 + ", neverRender2588=" + this.neverRender2588 + ", parent='" + this.parent + "', pivot=" + this.pivot + ", rotation" + this.rotation + ", bindPoseRotation2588" + this.bindPoseRotation2588 + ", mirror=" + this.mirror + ", inflate=" + this.inflate + ", debug=" + this.debug + ", cubes=" + Arrays.toString(this.cubes) + ", locators=" + Arrays.toString(this.locators) + "}";
        }
    }

    public static class Locator {
        private final String identifier;
        private final class_1160 position;

        public Locator(String identifier, class_1160 position) {
            this.identifier = identifier;
            this.position = position;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public class_1160 getPosition() {
            return this.position;
        }

        public String toString() {
            return "Locator{identifier='" + this.identifier + "', position=" + this.position + "}";
        }
    }

    public static class Poly {
        private final int[] positions;
        private final int[] normals;
        private final int[] uvs;

        public Poly(int[] positions, int[] normals, int[] uvs) {
            this.positions = positions;
            this.normals = normals;
            this.uvs = uvs;
        }

        public int[] getPositions() {
            return this.positions;
        }

        public int[] getNormals() {
            return this.normals;
        }

        public int[] getUVs() {
            return this.uvs;
        }

        public String toString() {
            return "Poly{positions=" + Arrays.toString(this.positions) + ", normals=" + Arrays.toString(this.normals) + ", uvs=" + Arrays.toString(this.uvs) + "}";
        }

        public static class Deserializer
        implements JsonDeserializer<Poly> {
            private static int[] parseVertex(JsonElement element) throws JsonParseException {
                if (!element.isJsonArray()) {
                    throw new JsonSyntaxException("Expected vertex to be a JsonArray, was " + class_3518.method_15266((JsonElement)element));
                }
                JsonArray array = element.getAsJsonArray();
                if (array.size() != 3) {
                    throw new JsonParseException("Expected 3 vertex values, was " + array.size());
                }
                return new int[]{array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt()};
            }

            public Poly deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.size() != 3 && jsonArray.size() != 4) {
                    throw new JsonSyntaxException("Expected 3 or 4 index values, was " + jsonArray.size());
                }
                int[] array1 = Deserializer.parseVertex(jsonArray.get(0));
                int[] array2 = Deserializer.parseVertex(jsonArray.get(1));
                int[] array3 = Deserializer.parseVertex(jsonArray.get(2));
                if (jsonArray.size() == 4) {
                    int[] array4 = Deserializer.parseVertex(jsonArray.get(3));
                    return new Poly(new int[]{array1[0], array2[0], array3[0], array4[0]}, new int[]{array1[1], array2[1], array3[1], array4[1]}, new int[]{array1[2], array2[2], array3[2], array4[2]});
                }
                return new Poly(new int[]{array1[0], array2[0], array3[0]}, new int[]{array1[1], array2[1], array3[1]}, new int[]{array1[2], array2[2], array3[2]});
            }
        }
    }

    public static class PolyMesh {
        private final boolean normalizedUvs;
        private final class_1160[] positions;
        private final class_1160[] normals;
        private final class_241[] uvs;
        private final Poly[] polys;
        private final PolyType polyType;

        public PolyMesh(boolean normalizedUvs, class_1160[] positions, class_1160[] normals, class_241[] uvs, Poly[] polys, PolyType polyType) {
            this.normalizedUvs = normalizedUvs;
            this.positions = positions;
            this.normals = normals;
            this.uvs = uvs;
            this.polys = polys;
            this.polyType = polyType;
        }

        public boolean isNormalizedUvs() {
            return this.normalizedUvs;
        }

        public class_1160[] getPositions() {
            return this.positions;
        }

        public class_1160[] getNormals() {
            return this.normals;
        }

        public class_241[] getUvs() {
            return this.uvs;
        }

        public Poly[] getPolys() {
            return this.polys;
        }

        public PolyType getPolyType() {
            return this.polyType;
        }

        public String toString() {
            return "PolyMesh{normalizedUvs=" + this.normalizedUvs + ", positions=" + Arrays.toString(this.positions) + ", normals=" + Arrays.toString(this.normals) + ", uvs=" + Arrays.toString(this.uvs) + ", polys=" + Arrays.toString(this.polys) + ", polyType=" + this.polyType + "}";
        }

        public static class Deserializer
        implements JsonDeserializer<PolyMesh> {
            private static PolyType parseType(JsonElement json) throws JsonParseException {
                if (!json.isJsonPrimitive()) {
                    throw new JsonSyntaxException("Expected String, was " + class_3518.method_15266((JsonElement)json));
                }
                for (PolyType polyType : PolyType.values()) {
                    if (!polyType.name.equalsIgnoreCase(json.getAsString())) continue;
                    return polyType;
                }
                throw new JsonSyntaxException("Unsupported poly type: " + json.getAsString() + ". Supported poly types: " + Arrays.toString(Arrays.stream(PolyType.values()).map(PolyType::getName).toArray(String[]::new)));
            }

            private static PolyType parseType(Poly[] polys) {
                if (polys.length == 0) {
                    return PolyType.TRIANGLES;
                }
                return polys[0].getPositions().length == 3 ? PolyType.TRIANGLES : PolyType.QUADS;
            }

            private static <T> T[] parsePositions(JsonObject json, String name, int size, Function<Integer, T[]> arrayGenerator, Function<JsonArray, T> generator) throws JsonParseException {
                JsonArray positionsJson = class_3518.method_15292((JsonObject)json, (String)name, null);
                if (positionsJson == null) {
                    return arrayGenerator.apply(0);
                }
                T[] positions = arrayGenerator.apply(positionsJson.size());
                for (int i = 0; i < positionsJson.size(); ++i) {
                    JsonElement element = positionsJson.get(i);
                    if (!element.isJsonArray()) {
                        throw new JsonSyntaxException("Expected " + name + " to be a JsonArray, was " + class_3518.method_15266((JsonElement)element));
                    }
                    JsonArray array = element.getAsJsonArray();
                    if (array.size() != size) {
                        throw new JsonParseException("Expected " + size + " " + name + " values, was " + array.size());
                    }
                    positions[i] = generator.apply(array);
                }
                return positions;
            }

            public PolyMesh deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                boolean normalizedUvs = class_3518.method_15258((JsonObject)jsonObject, (String)"normalized_uvs", (boolean)false);
                class_1160[] positions = Deserializer.parsePositions(jsonObject, "positions", 3, class_1160[]::new, j -> new class_1160(j.get(0).getAsFloat(), j.get(1).getAsFloat(), j.get(2).getAsFloat()));
                class_1160[] normals = Deserializer.parsePositions(jsonObject, "normals", 3, class_1160[]::new, j -> new class_1160(j.get(0).getAsFloat(), j.get(1).getAsFloat(), j.get(2).getAsFloat()));
                class_241[] uvs = Deserializer.parsePositions(jsonObject, "uvs", 2, class_241[]::new, j -> new class_241(j.get(0).getAsFloat(), j.get(1).getAsFloat()));
                if (!jsonObject.has("polys")) {
                    throw new JsonSyntaxException("Missing polys, expected to find a JsonArray or String");
                }
                JsonElement polysJson = jsonObject.get("polys");
                if (!(polysJson.isJsonArray() || polysJson.isJsonPrimitive() && polysJson.getAsJsonPrimitive().isString())) {
                    throw new JsonSyntaxException("Expected polys to be a JsonArray or String, was " + class_3518.method_15266((JsonElement)polysJson));
                }
                Poly[] polys = polysJson.isJsonArray() ? (Poly[])context.deserialize(polysJson, Poly[].class) : new Poly[]{};
                PolyType polyType = polysJson.isJsonPrimitive() ? Deserializer.parseType(polysJson) : Deserializer.parseType(polys);
                for (Poly poly : polys) {
                    if (poly.getPositions().length != polyType.getVertices()) {
                        throw new JsonSyntaxException("Expected positions to be of length " + polyType.getVertices() + ". Was " + poly.getPositions().length);
                    }
                    if (poly.getNormals().length != polyType.getVertices()) {
                        throw new JsonSyntaxException("Expected normals to be of length " + polyType.getVertices() + ". Was " + poly.getPositions().length);
                    }
                    if (poly.getUVs().length == polyType.getVertices()) continue;
                    throw new JsonSyntaxException("Expected positions to be of length " + polyType.getVertices() + ". Was " + poly.getPositions().length);
                }
                return new PolyMesh(normalizedUvs, positions, normals, uvs, polys, polyType);
            }
        }
    }

    public static class CubeUV {
        private final float u;
        private final float v;
        private final float uSize;
        private final float vSize;
        private final String materialInstance;

        public CubeUV(float u, float v, float uSize, float vSize, String materialInstance) {
            this.u = u;
            this.v = v;
            this.uSize = uSize;
            this.vSize = vSize;
            this.materialInstance = materialInstance;
        }

        public float getU() {
            return this.u;
        }

        public float getV() {
            return this.v;
        }

        public float getUSize() {
            return this.uSize;
        }

        public float getVSize() {
            return this.vSize;
        }

        public String getMaterialInstance() {
            return this.materialInstance;
        }

        public String toString() {
            return "CubeUV{uv=(" + this.u + "," + this.v + "), uvSize=(" + this.uSize + "," + this.vSize + "), materialInstance='" + this.materialInstance + "'}";
        }
    }

    public static class Cube {
        private final class_1160 origin;
        private final class_1160 size;
        private final class_1160 rotation;
        private final class_1160 pivot;
        private final boolean overrideInflate;
        private final float inflate;
        private final boolean overrideMirror;
        private final boolean mirror;
        private final CubeUV[] uv;

        public Cube(class_1160 origin, class_1160 size, class_1160 rotation, class_1160 pivot, boolean overrideInflate, float inflate, boolean overrideMirror, boolean mirror, CubeUV[] uv) {
            this.origin = origin;
            this.size = size;
            this.rotation = rotation;
            this.pivot = pivot;
            this.overrideInflate = overrideInflate;
            this.inflate = inflate;
            this.overrideMirror = overrideMirror;
            this.mirror = mirror;
            Validate.isTrue((uv.length == class_2350.values().length ? 1 : 0) != 0);
            this.uv = uv;
        }

        public class_1160 getOrigin() {
            return this.origin;
        }

        public class_1160 getSize() {
            return this.size;
        }

        public class_1160 getRotation() {
            return this.rotation;
        }

        public class_1160 getPivotX() {
            return this.pivot;
        }

        public boolean isOverrideInflate() {
            return this.overrideInflate;
        }

        public float getInflate() {
            return this.inflate;
        }

        public boolean isOverrideMirror() {
            return this.overrideMirror;
        }

        public boolean isMirror() {
            return this.mirror;
        }

        @Nullable
        public CubeUV getUV(class_2350 direction) {
            return this.uv[direction.method_10146()];
        }

        public CubeUV[] getUVs() {
            return this.uv;
        }

        public String toString() {
            return "Cube{origin=" + this.origin + ", size=" + this.size + ", rotation=" + this.rotation + ", pivot=" + this.pivot + ", overrideInflate=" + this.overrideInflate + ", inflate=" + this.inflate + ", overrideMirror=" + this.overrideMirror + ", mirror=" + this.mirror + ", northUV=" + this.getUV(class_2350.field_11043) + ", eastUV=" + this.getUV(class_2350.field_11034) + ", southUV=" + this.getUV(class_2350.field_11035) + ", westUV=" + this.getUV(class_2350.field_11039) + ", upUV=" + this.getUV(class_2350.field_11036) + ", downUV=" + this.getUV(class_2350.field_11033) + "}";
        }
    }

    public static enum PolyType {
        TRIANGLES("tri_list", 3),
        QUADS("quad_list", 4);

        private final String name;
        private final int vertices;

        private PolyType(String name, int vertices) {
            this.name = name;
            this.vertices = vertices;
        }

        public String getName() {
            return this.name;
        }

        public int getVertices() {
            return this.vertices;
        }
    }
}

